<?php

namespace App\Http\Controllers\Admin;

use Inertia\Inertia;
use App\Models\Contact;
use App\Utils\Helper;
use App\Enums\UserType;
use App\Enums\LanguageType;
use Illuminate\Http\Request;
use App\Enums\ContactStatusType;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;

class ContactController extends Controller
{
  public $adminRole = [UserType::Admin];
  public $isAdmin = false;
  public $page = null;

  public function __construct()
  {
    $this->middleware(function ($request, $next) {
      $user = auth()->user();
      $this->page = $this->getPage($request);
      $this->isAdmin = $user && in_array($user->role, $this->adminRole);
      return $next($request);
    });
  }

  public function index(Request $request)
  {
    $contact = Contact::filter($request)
      ->with('category')
      ->paginate(20);

    $data = [
      "title" => "{$this->page["label"]}",
      "status" => ContactStatusType::getValues(),
      "page" => $this->page,
      "contact" => collect($contact),
      "isAdmin" => $this->isAdmin,
    ];

    return Inertia::render("Admin/Contact/Index", $data);
  }

  public function update($id, Request $request)
  {
    if ($request->filled('status') && $this->isAdmin) return $this->updateStatus($id, $request);
    return redirect()->back()->with('error', 'Aksi yang dipilih tidak ditemukan');
  }

  protected function updateStatus($id, $request)
  {
    DB::beginTransaction();
    try {
      $contact = Contact::where(['id' => $id])->first();
      $status = in_array($request->status, ContactStatusType::getValues()) ? $request->status : $contact->status;
      
      if (!empty($contact)) {
        $contact->update([
          'status' => $status
        ]);
      }

      DB::commit();
      return redirect()->back()->with("success", "Update Status Kotak Masuk Berhasil");
    } catch (\Throwable $th) {
      DB::rollBack();
      return redirect()->back()->with("error", "Status Kotak Masuk Gagal Di Update. Cobalah beberapa saat lagi");
    }
  }


  protected function getAuthorize($request, $contact = null)
  {
    if ($this->isAdmin) return true;
    return true;
  }
  protected function getPage($request, $id = null)
  {
    $fields = \App\Utils\Helper::getFormFields($this->validation($request));

    $page = [
      "name" => "contact",
      "label" => "Kotak Masuk",
      "url" => "/admin/contact",
      "data" => null,
      "fields" => $fields,
    ];

    return $page;
  }
  protected function validation($request, $id = null)
  {
    $data = [
      "validation" => [],
      "default" => [
        "status" => ContactStatusType::New,
      ],
      "langs" => [],
      "lang_columns" => []
    ];

    return $data;
  }
}
