<?php

namespace App\Http\Controllers;

use Inertia\Inertia;
use App\Enums\UserType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class DashboardController extends Controller
{
  /**
   * Handle the incoming request.
   */
  public function __invoke(Request $request)
  {
    $data = [
      'title' => 'Dashboard'
    ];
    $allowedRole = [
      UserType::Admin,
      UserType::Editor,
    ];
    $user = auth()->user();
    if (in_array($user->role, $allowedRole)) return Inertia::render('Admin/Dashboard/Index', $data);
    return redirect('/');
  }
}
