<?php

namespace App\Http\Controllers\User;

use Inertia\Inertia;
use App\Utils\Helper;
use App\Enums\SeoType;
use App\Models\Profile;
use App\Models\Category;
use App\Enums\ProfileType;
use App\Enums\CategoryType;
use App\Http\Services\SeoService;
use App\Http\Controllers\Controller;
use App\Http\Services\TranslationService;

class CategoryController extends Controller
{
  public $companyName = '';
  public $baseFilter = [];
  public function __construct()
  {
    $this->middleware(function ($request, $next) {
      $this->baseFilter = [...Helper::publishStatus(), ...Helper::langStatus()];
      
      $this->companyName = config('app.name');
      $companyNameProfile = Profile::where(['type' => ProfileType::CompanyName, ...$this->baseFilter])->select(['type', 'content'])->first();
      if (!empty($companyNameProfile?->content)) {
        $this->companyName = $companyNameProfile?->content;
      }
      return $next($request);
    });
  }

  public function index()
  {
    $categories = Category::where(['type' => CategoryType::Product, ...$this->baseFilter])->get();

    $data = [
      ...SeoService::get(SeoType::CategoryIndex),
      'categories' => $categories,
    ];

    // dd($data);

    return Inertia::render('User/Category/Index', $data);
  }
}
