<?php

namespace App\Models;

use Carbon\Carbon;
use App\Models\Contact;
use App\Models\Product;
use Spatie\Sitemap\Tags\Url;
use App\Models\TranslatedGroup;
use App\Models\Traits\Published;
use App\Models\Traits\Filterable;
use Illuminate\Database\Eloquent\Model;
use Spatie\Sitemap\Contracts\Sitemapable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Category extends Model implements Sitemapable
{
  use HasFactory, SoftDeletes, Filterable, Published;
  protected $guarded = ['id'];

  public function product()
  {
    return $this->hasMany(Product::class, 'category_id', 'id');
  }
  public function contact()
  {
    return $this->hasMany(Contact::class, 'category_id', 'id');
  }
  public function translatedGroup()
  {
    return $this->belongsTo(\App\Models\TranslatedGroup::class, 'translated_group_id', 'id');
  }
  public function toSitemapTag(): Url | string | array
  {
    return Url::create(route('home.product.index', $this->slug))
      ->setLastModificationDate(Carbon::create($this->updated_at))
      ->setChangeFrequency(Url::CHANGE_FREQUENCY_DAILY)
      ->setPriority(0.8);
  }
}
