<?php

namespace App\Providers;

use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Auth\UserProvider;
use App\Models\FirebirdUser;

class FirebirdUserProvider implements UserProvider
{
    protected $model;

    public function __construct($model)
    {
        $this->model = $model;
    }

    public function retrieveById($identifier): ?Authenticatable
    {
        return $this->model->find($identifier);
    }

    public function retrieveByToken($identifier, $token): ?Authenticatable
    {
        return null; // jika tidak menggunakan remember_token
    }

    public function updateRememberToken(Authenticatable $user, $token): void
    {
        // tidak digunakan
    }

    public function retrieveByCredentials(array $credentials): ?Authenticatable
    {
        return $this->model->where('LOGIN', strtoupper($credentials['LOGIN']))->first();
    }

    public function validateCredentials(Authenticatable $user, array $credentials): bool
    {
      $stored_password = isset($user->USERPASSWORD) ? $user->USERPASSWORD : '';
      $stored_password = \App\Utils\Helper::descramble($stored_password);

      return $stored_password === $credentials['USERPASSWORD'];
    }
}