<?php

declare(strict_types=1);

namespace App\Enums;

use BenSampo\Enum\Enum;

final class ConfigurationSelectOptions extends Enum
{
  const CTA_ACTION = [
    // [
    //   'value' => OriginStatusType::Nonactive,
    //   'label' => 'Nonaktifkan',
    // ],
    [
      'value' => 'email',
      'label' => 'Email',
      'description' => 'CTA akan dialihkan ke halaman kontak untuk submit form',
    ],
    [
      'value' => 'whatsapp',
      'label' => 'Whatsapp',
      'description' => 'CTA akan menggunakan nomor whatsapp dibawah',
      'form_properties' => [
        [
          [
            'form' => 'input',
            'props' => [
              'isLabel' => false,
              'name' => 'form.CTA_FORM.value',
              'type' => 'tel',
              'placeHolder' => 'contoh: 0812xxxxxxxx'
            ]
          ]
        ]
      ]
    ],
    [
      'value' => 'chat',
      'label' => 'Chat Customer Support',
      'description' => 'CTA akan menggunakan fitur chat customer support. Jika fitur chat tidak diaktifkan, maka akan menggunakan CTA Email'
    ],
  ];
}
