<?php

namespace App\Http\Controllers\Admin;

use Inertia\Inertia;
use Illuminate\Http\Request;
use App\Models\Configuration;
use App\Enums\OriginStatusType;
use App\Enums\ConfigurationType;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Enums\ConfigurationSelectOptions;
use App\Utils\Helper;

class ConfigurationController extends Controller
{
  private $options, $hardReload, $multipleInput;

  public function __construct()
  {
    $this->options = array_values(ConfigurationType::asArray());
    $this->hardReload = false;
    $this->multipleInput = [];
  }
  public function index(Request $request)
  {
    $inputType = [
      'CTA_ACTION' => 'select',
      'CS_CHAT' => 'toggle',
    ];

    $selectOptions = [
      'CTA_ACTION' => ConfigurationSelectOptions::CTA_ACTION
    ];
    $hiddenOptions = [];

    $disabledInputs = ['CTA_FORM'];
    $configurations = Configuration::get()->groupBy('type');

    $disabledConfigs = collect($this->options)->map(function ($option) use ($configurations, $disabledInputs) {
      if (!in_array($option, $disabledInputs)) return null;
      if (isset($configurations[$option])) return [$option => $configurations[$option]];
      $configData[$option][0] = [
        'type' => $option,
        'status' => OriginStatusType::Nonactive,
        'value' => null,
        'description' => null
      ];
      return $configData;
    })->filter()->values();

    $configurations = collect($this->options)->map(function ($option) use ($configurations, $disabledInputs) {
      if (in_array($option, $disabledInputs)) return null;
      if (isset($configurations[$option])) return [$option => $configurations[$option]];
      $configData[$option][0] = [
        'type' => $option,
        'status' => OriginStatusType::Nonactive,
        'value' => null,
        'description' => null
      ];
      return $configData;
    })->filter()->values();

    $options = collect($this->options)->filter(function ($option) use ($disabledInputs) {
      return !in_array($option, $disabledInputs);
    })->values();

    $data = [
      'title' => 'Konfigurasi',
      'configurations' => $configurations,
      'status' => array_values(OriginStatusType::asArray()),
      'options' => $options,
      'inputType' => $inputType,
      'selectOptions' => $selectOptions,
      'hiddenOptions' => $hiddenOptions,
      'disabledConfigs' => $disabledConfigs,
      'multipleInput' => $this->multipleInput,
    ];
    return Inertia::render('Admin/Configuration/Index', $data);
  }

  public function store(Request $request)
  {
    DB::beginTransaction();
    try {
      $requestData =   $request->all();
      foreach ($requestData as $data) {
        $data = collect($data)->map(function ($value) {
          collect($value)->map(function ($config) {
            $selecteds = collect(array_keys($config))
              ->filter(fn($selected) => (str($selected)->startsWith('form')))
              ->values();

            $configData = [
              'type' => $config['type'],
              'status' => $config['is_active'] == true ? OriginStatusType::Active : OriginStatusType::Nonactive,
              'value' => $config['value'],
              'description' => $config['description']
            ];

            $this->saveData($config, $configData);

            if ($selecteds->isNotEmpty()) {
              foreach ($selecteds as $selected) {
                [$prefix, $type, $column] = explode('.', $selected);
                $selectedConfig = $config;
                $selectedId = "$type.id";
                if (!empty($selectedConfig[$selectedId])) {
                  $selectedConfig['id'] = $selectedConfig[$selectedId];
                }                

                $value = $config[$selected];
                $selectedData = $configData;
                $selectedData['type'] = $type;
                $selectedData[$column] = $value;

                $this->saveData($selectedConfig, $selectedData);
              }
            }
          });
        });
      }

      DB::commit();
      if ($this->hardReload) {
        return Inertia::location('/admin/configuration');
      }
      return redirect()->back()->with('success', "Konfigurasi berhasil disimpan");
    } catch (\Throwable $th) {
      DB::rollBack();
      return redirect()->back()->with('error', $th->getMessage() ?? 'Kesalahan Server. Konfigurasi gagal disimpan');
    }
  }

  public function destroy($id)
  {
    try {
      $configuration = Configuration::where('id', $id)->first();
      $delete = $configuration->delete();
      return redirect('/admin/configuration')->with('success', 'Hapus Konfigurasi Berhasil');
    } catch (\Throwable $th) {
      return redirect('/admin/configuration')->with('error', 'Kesalahan Server. Hapus konfigurasi gagal');
    }
  }

  public function saveData($config, $configData)
  {
    if (isset($config['id'])) {
      $configuration = Configuration::where('id', $config['id'])->first();
      $configuration->update($configData);
    } else {
      $this->hardReload = true;
      $configuration = Configuration::create($configData);
    }

    Helper::saveCache("config.$configuration->type", $configuration);
  }
}
