<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use App\Models\Chat;
use Inertia\Inertia;
use App\Utils\Helper;
use App\Enums\SeoType;
use App\Models\Banner;
use App\Models\Career;
use App\Models\Client;
use App\Models\Gallery;
use App\Models\Profile;
use App\Models\Category;
use App\Models\Testimony;
use App\Enums\ProfileType;
use App\Enums\CategoryType;
use App\Models\UniquePoint;
use Illuminate\Http\Request;
use App\Models\Configuration;
use App\Enums\OriginStatusType;
use App\Enums\ConfigurationType;
use App\Http\Services\SeoService;
use App\Http\Controllers\Controller;

class HomeController extends Controller
{
  public $companyName = '';
  public $baseFilter = [];
  public function __construct()
  {
    $this->middleware(function ($request, $next) {
      $this->baseFilter = [...Helper::publishStatus(), ...Helper::langStatus()];

      $this->companyName = config('app.name');
      $companyNameProfile = Profile::where(['type' => ProfileType::CompanyName, ...$this->baseFilter])->select(['type', 'content'])->first();
      if (!empty($companyNameProfile?->content)) {
        $this->companyName = $companyNameProfile?->content;
      }
      return $next($request);
    });
  }
  public function index(Request $request)
  {
    $banners = Banner::where([...$this->baseFilter])->get();
    $uniquePoints = UniquePoint::where([...$this->baseFilter])->get();
    $categories = Category::where(['type' => CategoryType::Product, ...$this->baseFilter])->get();
    $testimonies = Testimony::where([...$this->baseFilter])->get();
    $clients = Client::where([...$this->baseFilter])->get();
    $articles = Blog::where([...$this->baseFilter])
      ->whereRelation('category', 'is_featured', '=', 1)
      ->limit(3)
      ->orderByDesc('published_at')
      ->get();

    $aboutTypes = [
      ProfileType::CompanyName => null,
      ProfileType::Tagline => null,
      ProfileType::About => null,
      ProfileType::AboutImage => null,
    ];

    $profiles = Profile::where([...$this->baseFilter])
      ->whereIn('type', array_keys($aboutTypes))
      ->select(['type', 'content'])
      ->get()
      ->groupBy('type');

    $abouts = collect($aboutTypes)->map(function ($value, $key) use ($profiles) {
      if (!empty($profiles[$key])) {
        $profile = $profiles[$key]->first();
        return $profile?->content;
      }
    });

    $data = [
      ...SeoService::get(SeoType::Default),
      'banners' => $banners,
      'uniquePoints' => $uniquePoints,
      'testimonies' => $testimonies,
      'clients' => $clients,
      'articles' => $articles,
      'categories' => $categories,
      ...$abouts
    ];

    return Inertia::render('User/Home/Index', $data);
  }
  public function about()
  {
    $profiles = Profile::where([...$this->baseFilter])->select(['type', 'label', 'content'])->get()->groupBy('type')->toArray();

    $data = [
      ...SeoService::get(SeoType::About),
      'profiles' => $profiles,
    ];

    // dd($data);

    return Inertia::render('User/Home/About', $data);
  }

  public function career()
  {
    $careers = Career::where([...$this->baseFilter])->get();

    $data = [
      ...SeoService::get(SeoType::Career),
      'careers' => $careers,
    ];

    // dd($data);

    return Inertia::render('User/Home/Career', $data);
  }
  public function gallery()
  {
    $galleries = Gallery::where([...$this->baseFilter])->get();

    $data = [
      ...SeoService::get(SeoType::Gallery),
      'galleries' => $galleries,
    ];

    // dd($data);

    return Inertia::render('User/Home/Gallery', $data);
  }
  public function afterSales()
  {
    $afterSales = Category::where(['type' => CategoryType::AfterSales, ...$this->baseFilter])->get();;
    $requirementAfterSales = Profile::where(['type' => ProfileType::RequirementAfterSales, ...$this->baseFilter])->select(['type', 'content'])->first();

    $ctaAction = Configuration::select('type', 'value')->where(['type' => ConfigurationType::CTA_ACTION, 'status' => OriginStatusType::Active])->first();
    $ctaForm = null;

    if (in_array($ctaAction?->value, ['whatsapp'])) {
      $ctaForm = Configuration::select('type', 'value')->where(['type' => ConfigurationType::CTA_FORM, 'status' => OriginStatusType::Active])->first();
    }

    $data = [
      ...SeoService::get(SeoType::AfterSales),
      'afterSales' => $afterSales,
      'requirementAfterSales' => $requirementAfterSales,
      'ctaAction' => $ctaAction,
      'ctaForm' => $ctaForm,
    ];

    // dd($data);

    return Inertia::render('User/Home/AfterSales', $data);
  }
}
