<?php

namespace App\Http\Controllers;

use App\Enums\CategoryType;
use Carbon\Carbon;
use App\Models\Blog;
use App\Models\Product;
use App\Models\Category;
use App\Models\BlogCategory;
use Spatie\Sitemap\Tags\Url;
use Spatie\Sitemap\Sitemap;
use App\Http\Controllers\Controller;

class SitemapController extends Controller
{
  public function __invoke()
  {
    return Sitemap::create()
      ->add(Url::create('/')
        ->setLastModificationDate(Carbon::now())
        ->setChangeFrequency(Url::CHANGE_FREQUENCY_DAILY)
        ->setPriority(0.8))

      ->add(Url::create(route('home.about'))
        ->setLastModificationDate(Carbon::now())
        ->setChangeFrequency(Url::CHANGE_FREQUENCY_DAILY)
        ->setPriority(0.8))
      ->add(Url::create(route('home.contact.index'))
        ->setLastModificationDate(Carbon::now())
        ->setChangeFrequency(Url::CHANGE_FREQUENCY_DAILY)
        ->setPriority(0.8))
      ->add(Url::create(route('home.afterSales'))
        ->setLastModificationDate(Carbon::now())
        ->setChangeFrequency(Url::CHANGE_FREQUENCY_DAILY)
        ->setPriority(0.8))
      ->add(Url::create(route('home.career'))
        ->setLastModificationDate(Carbon::now())
        ->setChangeFrequency(Url::CHANGE_FREQUENCY_DAILY)
        ->setPriority(0.8))
      ->add(Url::create(route('home.gallery'))
        ->setLastModificationDate(Carbon::now())
        ->setChangeFrequency(Url::CHANGE_FREQUENCY_DAILY)
        ->setPriority(0.8))
      ->add(Category::published()->where(['type' => CategoryType::Product])->get())
      ->add(Product::published()->with('category')->get())
      ->add(Url::create(route('home.blog.index'))
        ->setLastModificationDate(Carbon::now())
        ->setChangeFrequency(Url::CHANGE_FREQUENCY_DAILY)
        ->setPriority(0.8))
      ->add(Blog::published()->get())
      ->add(BlogCategory::published()->get());
  }
}
