<?php

namespace App\Http\Controllers\User;

use Inertia\Inertia;
use App\Utils\Helper;
use App\Enums\SeoType;
use App\Models\Contact;
use App\Models\Profile;
use App\Models\Category;
use App\Enums\ProfileType;
use App\Enums\CategoryType;
use Illuminate\Http\Request;
use App\Http\Services\SeoService;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Services\TranslationService;

class ContactController extends Controller
{
  public $companyName = '';
  public $baseFilter = [];
  public $page = null;
  public function __construct()
  {
    $this->middleware(function ($request, $next) {
      $this->page = $this->getPage($request);
      $this->baseFilter = [...Helper::publishStatus(), ...Helper::langStatus()];

      $this->companyName = config('app.name');
      $companyNameProfile = Profile::where(['type' => ProfileType::CompanyName, ...$this->baseFilter])->select(['type', 'content'])->first();
      if (!empty($companyNameProfile?->content)) {
        $this->companyName = $companyNameProfile?->content;
      }
      return $next($request);
    });
  }
  public function index()
  {
    $addressMap = Profile::where(['type' => ProfileType::AddressMap, ...$this->baseFilter])->select(['type', 'label', 'content'])->get()->toArray();
    $categories = Category::where(['type' => CategoryType::Product, ...$this->baseFilter])->get();

    $data = [
      ...SeoService::get(SeoType::ContactIndex),
      'addressMap' => $addressMap,
      'categories' => $categories,
      'page' => $this->page,
    ];

    // dd($data);

    return Inertia::render('User/Contact/Index', $data);
  }

  public function store(Request $request)
  {
    $validation = $this->validation($request);
    $validatedData = $request->validate($validation["validation"]);

    DB::beginTransaction();
    try {
      $validationResult = $this->processValidateData($validatedData, $validation, $request);
      if ($validationResult instanceof \Illuminate\Http\RedirectResponse) return $validationResult;

      [$validatedData] = $validationResult;

      $contact = Contact::create($validatedData);

      DB::commit();
      return redirect(\App\Utils\Helper::getRefurl(request()) ?? $this->page['url'])->with("success", "Tambah {$this->page["label"]} berhasil");
    } catch (\Throwable $th) {
      DB::rollBack();
      return redirect()->back()->with("error", "Kesalahan Server. Tambah {$this->page["label"]} gagal");
    }
  }

  protected function processValidateData($validatedData, $validation, $request, $category = null)
  {
    return [$validatedData];
  }

  protected function getPage($request, $id = null)
  {
    $fields = \App\Utils\Helper::getFormFields($this->validation($request));

    $page = [
      "name" => "contact",
      "label" => "Kontak Kami",
      "url" => "/contact",
      "data" => null,
      "fields" => $fields,
    ];

    return $page;
  }
  protected function validation($request, $id = null)
  {
    $data = [
      "validation" => [
        'name' => 'required',
        'phone' => 'required',
        'email' => 'required',
        'company_name' => 'required',
        'category_id' => 'required',
        'capacity' => 'required',
        'project_name' => 'required',
        'location' => 'required',
        'status' => 'nullable',
      ],
      "default" => [],
      "langs" => [],
      "lang_columns" => []
    ];

    return $data;
  }
}
