<?php

namespace App\Http\Controllers\User;

use Inertia\Inertia;
use App\Utils\Helper;
use App\Enums\SeoType;
use App\Models\Product;
use App\Models\Profile;
use App\Models\Category;
use App\Enums\ProfileType;
use App\Enums\LanguageType;
use App\Models\Configuration;
use App\Enums\OriginStatusType;
use App\Enums\ConfigurationType;
use App\Http\Services\SeoService;
use App\Http\Controllers\Controller;
use App\Http\Services\TranslationService;

class ProductController extends Controller
{
  public $companyName = '';
  public $baseFilter = [];
  public function __construct()
  {
    $this->middleware(function ($request, $next) {
      $this->baseFilter = [...Helper::publishStatus(), ...Helper::langStatus()];

      $this->companyName = config('app.name');
      $companyNameProfile = Profile::where(['type' => ProfileType::CompanyName, ...$this->baseFilter])->select(['type', 'content'])->first();
      if (!empty($companyNameProfile?->content)) {
        $this->companyName = $companyNameProfile?->content;
      }
      return $next($request);
    });
  }
  public function index($categorySlug)
  {
    $category = Category::published()->where(['slug' => $categorySlug])->first();
    if (!$category) return Helper::redirectBack('error', 'Produk tidak ditemukan');
    $products = Product::published()->with('productImage','brand')->where(['category_id' => $category->id])->paginate(9);
    $products = collect($products);

    $meta = [
      'title' => "$category->name | " . config('app.name'),
      'description' => "$category->seo_description | " . config('app.name'),
      'keywords' => "$category->seo_keyword | " . config('app.name'),
    ];

    $seo = SeoService::get(SeoType::ProductIndex, $meta);

    $data = [
      ...$seo,
      'category' => $category,
      'products' => $products,
    ];

    // dd($data);

    $minutes = now()->diffInMinutes(now()->addYear());
    $langCookie = cookie('language', $category?->lang ?: LanguageType::Id, $minutes, '/', null, false, false);
    
    $response = Inertia::render('User/Product/Index', $data)->toResponse(request());
    return $response->withCookie($langCookie);
  }
  public function show($categorySlug, $productSlug)
  {
    $category = Category::published()->where(['slug' => $categorySlug])->first();
    if (!$category) return Helper::redirectBack('error', 'Produk tidak ditemukan');
    $product = Product::published()->with('productImage', 'brand')->where(['category_id' => $category->id, 'slug' => $productSlug])->first();
    if (!$product) return Helper::redirectBack('error', 'Detail Produk tidak ditemukan');

    $appUrl = rtrim(config('app.url'), '/');
    $imageUrl = $product->productImage?->first()?->value ?: '/image/icon.png';

    $meta = [
      'title' => "{$product->brand->name} $product->name | " . config('app.name'),
      'description' => "$product->seo_description | " . config('app.name'),
      'keywords' => "$product->seo_keyword | " . config('app.name'),
      'type' => 'Service',
      'image' => $appUrl . $imageUrl,
      'brand' => $product->brand->name,
    ];

    $seo = SeoService::get(SeoType::ProductIndex, $meta);

    $data = [
      ...$seo,
      'category' => $category,
      'product' => $product,
    ];

    // dd($data);

    $minutes = now()->diffInMinutes(now()->addYear());
    $langCookie = cookie('language', $category?->lang ?: LanguageType::Id, $minutes, '/', null, false, false);
    
    $response = Inertia::render('User/Product/Show', $data)->toResponse(request());
    return $response->withCookie($langCookie);
  }
}
