<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class FilterUrl
{
  public function handle(Request $request, Closure $next)
  {
    $fullUrl = $request->fullUrl();
    $path    = urldecode(parse_url($fullUrl, PHP_URL_PATH) ?? '');

    $encodedSlashCount = substr_count($fullUrl, '%2F');
    $blogCount = substr_count($path, '/blog/') + substr_count($fullUrl, 'blog%2F');

    $route = $request->route();
    $routeName = $route?->getName();

    if (!$routeName || !str_starts_with($routeName, 'home.')) {
      return response('', 410)->header('X-Robots-Tag', 'noindex, nofollow');
    }

    $isGarbage = $encodedSlashCount > 5
      || $blogCount > 3
      || preg_match('/(blog(%2F|\/)){2,}/i', $fullUrl);

    if ($isGarbage) {
      return response('', 410)->header('X-Robots-Tag', 'noindex, nofollow');
    }

    return $next($request);
  }
}
