<?php

namespace App\Models;

use App\Models\Product;
use App\Models\Traits\Filterable;
use App\Models\Traits\Published;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Brand extends Model
{
  use HasFactory, Filterable, Published;
  protected $guarded = ['id'];

  public function product()
  {
    return $this->hasMany(Product::class, 'brand_id', 'id');
  }
}