<?php

namespace App\Models;

use App\Models\User;
use App\Models\ChatMessage;
use App\Models\ChatAttachment;
use App\Models\Traits\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Chat extends Model
{
  use HasFactory, Filterable;
  protected $guarded = ['id'];
  public function user()
  {
    return $this->hasOne(User::class, 'id', 'user_id')->withTrashed();
  }
  public function message()
  {
    return $this->hasMany(ChatMessage::class, 'chat_id', 'id')->orderBy('id');
  }
  public function attachment()
  {
    return $this->hasMany(ChatAttachment::class, 'chat_id', 'id');
  }
}
