<?php

namespace App\Models;

use App\Models\Chat;
use App\Models\ChatMessage;
use App\Models\Traits\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ChatAttachment extends Model
{
  use HasFactory, Filterable;
  protected $guarded = ['id'];

  public function chat()
  {
    return $this->belongsTo(Chat::class, 'chat_id', 'id');
  }
  public function message()
  {
    return $this->belongsTo(ChatMessage::class, 'chat_message_id', 'id');
  }
}
