<?php

namespace App\Models;

use App\Models\Chat;
use App\Models\ChatAttachment;
use App\Models\Traits\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ChatMessage extends Model
{
  use HasFactory, Filterable;
  protected $guarded = ['id'];

  public function chat()
  {
    return $this->belongsTo(Chat::class, 'chat_id', 'id');
  }

  public function imageAttachment()
  {
    return $this->hasMany(ChatAttachment::class, 'chat_message_id', 'id')->where('is_image', true);
  }
  public function otherAttachment()
  {
    return $this->hasMany(ChatAttachment::class, 'chat_message_id', 'id')->where('is_image', false);
  }
}
