<?php

namespace App\Models;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Brand;
use App\Models\Category;
use App\Models\ProductImage;
use Spatie\Sitemap\Tags\Url;
use App\Models\TranslatedGroup;
use App\Models\Traits\Published;
use App\Models\Traits\Filterable;
use Illuminate\Database\Eloquent\Model;
use Spatie\Sitemap\Contracts\Sitemapable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Product extends Model implements Sitemapable
{
  use HasFactory, Filterable, Published;
  protected $guarded = ['id'];

  public function category()
  {
    return $this->belongsTo(Category::class, 'category_id', 'id')->withTrashed();
  }
  public function user()
  {
    return $this->belongsTo(User::class, 'user_id', 'id')->withTrashed();
  }
  public function productImage()
  {
    return $this->hasMany(ProductImage::class, 'product_id', 'id');
  }
  public function brand()
  {
    return $this->belongsTo(Brand::class, 'brand_id', 'id');
  }
  public function translatedGroup()
  {
    return $this->belongsTo(\App\Models\TranslatedGroup::class, 'translated_group_id', 'id');
  }
  public function toSitemapTag(): Url | string | array
  {
    if (!$this->category) {
      return [];
    }

    $categoryUrl = Url::create(route('home.product.index', $this->category->slug))
      ->setLastModificationDate($this->category->updated_at)
      ->setChangeFrequency(Url::CHANGE_FREQUENCY_DAILY)
      ->setPriority(0.9);

    $productUrl = Url::create(
      route('home.product.show', [
        'category' => $this->category->slug,
        'product' => $this->slug
      ])
    )
      ->setLastModificationDate($this->updated_at)
      ->setChangeFrequency(Url::CHANGE_FREQUENCY_WEEKLY)
      ->setPriority(0.8);

    return [$categoryUrl, $productUrl];
  }
}
