<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TranslatedGroup extends Model
{
  protected $guarded = ['id'];

  public function category()
  {
    return $this->hasMany(\App\Models\Category::class, 'translated_group_id', 'id')->withTrashed();
  }
  public function product()
  {
    return $this->hasMany(\App\Models\Product::class, 'translated_group_id', 'id');
  }
  public function blog()
  {
    return $this->hasMany(\App\Models\Blog::class, 'translated_group_id', 'id');
  }
  public function career()
  {
    return $this->hasMany(\App\Models\Career::class, 'translated_group_id', 'id');
  }
  public function gallery()
  {
    return $this->hasMany(\App\Models\Gallery::class, 'translated_group_id', 'id');
  }
  public function blogCategory()
  {
    return $this->hasMany(\App\Models\BlogCategory::class, 'translated_group_id', 'id')->withTrashed();
  }
  public function testimony()
  {
    return $this->hasMany(\App\Models\Testimony::class, 'translated_group_id', 'id');
  }
  public function uniquePoint()
  {
    return $this->hasMany(\App\Models\UniquePoint::class, 'translated_group_id', 'id');
  }
  public function client()
  {
    return $this->hasMany(\App\Models\Client::class, 'translated_group_id', 'id');
  }
  public function profile()
  {
    return $this->hasMany(\App\Models\Profile::class, 'translated_group_id', 'id');
  }
  public function seo()
  {
    return $this->hasMany(\App\Models\Seo::class, 'translated_group_id', 'id');
  }
  public function banner()
  {
    return $this->hasMany(\App\Models\Banner::class, 'translated_group_id', 'id');
  }
}
