import useLang from "@/utlis/useLang";
import { usePage } from "@inertiajs/react";
import UserChatModal from "./Default/UserChatModal";
import { whatsappNumber } from "@/utlis/format";


export default function CTA() {
  const { props } = usePage()
  const handleAction = () => {
    const action = props?.config?.CTA_ACTION
    if (action === "whatsapp" && props?.config?.CTA_FORM) {
      window.open(`https://wa.me/${whatsappNumber(props?.config?.CTA_FORM)}`, "_blank")
      return
    }

    window.location.href = `/contact`
  }

  return (
    <div className="w-full h-full bg-[#0399DB] relative text-white flex items-center justify-center p-5 sm:p-10 ">
      <div
        className="absolute bg-fixed top-0 bg-[#0399DB] w-full  h-full bg-contain bg-repeat-y bg-center flex flex-row justify-center items-center opacity-85 bg-blend-multiply"
        style={{ backgroundImage: "url('/image/machine/Rectangle-171.webp')" }}
      ></div>
      <div className="absolute top-0 left-0 w-full h-full bg-black opacity-50"></div>

      <div className="z-10 text-center h-full w-full flex flex-col gap-2 items-center justify-between lg:p-10">
        <h1 className="h1">
          {useLang("CTA.h1")}
        </h1>
        <p className="p">{useLang("CTA.h2")}</p>

        {props?.config?.CTA_ACTION === "chat" && !!props?.config?.CS_CHAT ? (
          <UserChatModal ModalButton={() => (
            <>
              <button aria-label="chat" className="bg-[#0399DB] hover:bg-white transition-all duration-300 hover:text-[#0399DB] text-white py-[1px] px-2 sm:py-1 sm:px-3 lg:py-2 lg:px-4 rounded-sm sm:rounded-md lg:rounded-md mt-10 h3">
                {useLang("CTA.btn")}
              </button>
            </>
          )} />
        ) : (
          <button onClick={handleAction}
           className="bg-[#0399DB] hover:bg-white transition-all duration-300 hover:text-[#0399DB]  border-2 border-[#0399DB] text-white   px-4 py-2 rounded-md  mt-10 h3">
            {useLang("CTA.btn")}
          </button>
        )}
      </div>
    </div>
  )
}

