import { usePage } from "@inertiajs/react";
import { useEffect } from "react";
import { ToastContainer, toast } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';

function FlashMessage() {
  const { flash } = usePage().props;

  useEffect(() => {
    if (flash?.success) {
      toast(flash.success, { type: 'success' });
    }
    if (flash?.message) {
      toast(flash.message, { type: 'success' });
    }
    if (flash?.error) {
      toast(flash.error, { type: 'error', autoClose: 10000 });
    }
  }, [flash]);

  return (<><ToastContainer className="!font-medium text-lg !w-fit" draggable={true} draggablePercent={80}/></>);
}

export default FlashMessage;
