import useButtonTitle from "@/utlis/useButtonTitle"
import useLang from "@/utlis/useLang"
import { Link, usePage } from "@inertiajs/react"
import { FaLink, FaPhoneAlt } from "react-icons/fa"
import { IoIosMail, IoLogoWhatsapp } from "react-icons/io"
import { PiMapPinFill } from "react-icons/pi"
import { RiFacebookCircleFill, RiInstagramFill, RiYoutubeFill } from "react-icons/ri"

function Footer() {
  const { appName, footer } = usePage().props
  const title = useButtonTitle()

  const fontSizeStyle_p = `
   [&_p]:text-neutral-700
  [&_p]:p
`

  function removeZero(number) {
    number = number.replace(/\D/g, "")

    if (number.startsWith(0)) {
      number = number.slice(1)
    }

    return number
  }

  return (
    <>
      <div className="flex items-center justify-center h-20 lg:h-[15vh]  lg:px-40 ">
        <div className="border flex-1 border-[#0399DB]"></div>
        <div className="h-20 w-20 p-5">
          <img src="/image/logos/Gamatech_logo.webp" alt="" />
        </div>
        <div className="border flex-1 border-[#0399DB]"></div>
      </div>

      <div className="w-full h-full lg:px-10 2xl:px-0  text-white flex lg:flex flex-col md:flex-row  gap-3 lg:gap-0 2xl:gap-5 lg:py-10 max-w-[85rem] mx-auto">
        <div className=" h-full flex-1  grid px-6 md:justify-center gap-1 ">
          <div className=" flex  items-center gap-2 ">
            <PiMapPinFill size={14} color="#0399DB" />
            <h2 className="h3 font-semibold  text-[#0399DB]">{useLang("footer.office")}</h2>
          </div>
          <div className={`text-editor-content ${fontSizeStyle_p} `} dangerouslySetInnerHTML={{ __html: footer.officeAddress }}></div>
        </div>
        <div className=" h-full flex-1  grid px-6 md:justify-center gap-1  lg:text-left">
          <div className="flex  items-center gap-2 ">
            <FaLink size={13} color="#0399DB" />
            <h2 className="h3 font-semibold  text-[#0399DB]">{useLang("footer.contact")}</h2>
          </div>
          <div className="flex flex-col p text-neutral-700 ">
            <div className="flex  items-center gap-2 text-neutral-700">
              <FaPhoneAlt />
              <a title={`${title}`} className="hover:text-[#0399DB] " href={`tel:+62${removeZero(footer.phone)}`}>
                {footer.phone}
              </a>
            </div>
            <div className="flex  items-center gap-2">
              <IoIosMail />
              <a title={`${title}`} className="hover:text-[#0399DB]" href={`mailto:${footer.email}`}>
                {footer.email}
              </a>
            </div>
            <div className="flex  items-center gap-2">
              <IoLogoWhatsapp />
              <a title={`${title}`} className="hover:text-[#0399DB]" href={`https://wa.me/62${removeZero(footer.whatsapp)}`}>
                {footer.whatsapp}
              </a>
            </div>
          </div>

          <div className="flex  z-[101] items-center gap-1 lg:gap-2 ">
            <a
              target="_blank"
              href={`${footer.instagram}`}
              title={`${title}`}
              className="hover:text-[#064D6C] text-[#0399DB] cursor-pointer scale-110 hover:scale-125 transition-all duration-300 "
            >
              <RiInstagramFill className="text-[20px]" />
            </a>
            <a
              title={`${title}`}
              target="_blank"
              href={`${footer.facebook}`}
              className="hover:text-[#064D6C] text-[#0399DB] cursor-pointer hover:scale-110 transition-all duration-300 "
            >
              <RiFacebookCircleFill className="text-[23px]" />
            </a>
            <a
              title={`${title}`}
              target="_blank"
              href={`${footer.youtube}`}
              className="hover:text-[#064D6C] text-[#0399DB] cursor-pointer hover:scale-110 transition-all duration-300 "
            >
              <RiYoutubeFill className="text-[24px]" />
            </a>
          </div>
        </div>

        <div className=" h-full flex-1  grid px-6 md:justify-center gap-1  ">
          <div className="flex  items-center gap-2 ">
            <PiMapPinFill size={14} color="#0399DB" />
            <h2 className="h3   text-[#0399DB]">{useLang("footer.warehouse")}</h2>
          </div>

          <div className={`text-editor-content ${fontSizeStyle_p} `} dangerouslySetInnerHTML={{ __html: footer.warehouseAddress }}></div>
        </div>

        <div className=" h-full flex-1  grid px-6 md:justify-center gap-1 ">
          <div className="flex  items-center gap-2 ">
            <FaLink size={13} color="#0399DB" />
            <h2 className="h3 text-[#0399DB]">{useLang("footer.quickLinks")}</h2>
          </div>
          <div className="flex flex-col p text-neutral-700 ">
            <a className="hover:text-[#0399DB] w-fit  z-[101]" title={`${title}`} href="/about">
              {useLang("footer.quickLinks.about")}
            </a>
            <a className="hover:text-[#0399DB]  w-fit z-[101]" title={`${title}`} href="/product">
              {useLang("footer.quickLinks.products")}
            </a>
            <a className="hover:text-[#0399DB]  w-fit z-[101]" title={`${title}`} href="/gallery">
              {useLang("footer.quickLinks.gallery")}
            </a>
            <a className="hover:text-[#0399DB]  w-fit z-[101]" title={`${title}`} href="/contact">
              {useLang("footer.quickLinks.contact")}
            </a>
            <a className="hover:text-[#0399DB]  w-fit z-[101]" title={`${title}`} href="/blog">
              {useLang("footer.quickLinks.blog")}
            </a>
            <a className="hover:text-[#0399DB]  z-[101]" title={`${title}`} href="/career">
              {useLang("footer.quickLinks.career")}
            </a>
          </div>
        </div>
      </div>

      <div className="w-full h-20 md:h-10 flex justify-center items-center my-2">
        <a href="https://jaringmitramandiri.com/" target="_blank" className="  px-5 text-neutral-600 text-xs text-center">
          Copyright {new Date().getFullYear()} © All Rights Reserved. <br className="block md:hidden" /> Developed by <span className="font-semibold hover:text-[#0399DB]">Jaring Mitra Mandiri</span>
        </a>
      </div>
    </>
  )
}

export default Footer
