import { router, usePage } from "@inertiajs/react";
import { setCookie } from "@/utlis/format";
import FilterColumn from "./FilterColumn";

function LangFilter({name='lang'}) {
  const { props } = usePage()

  const handleChange = (e) => {    
    setCookie('language', `${e?.target?.value}`)
    router.get(`?`)
  }

  return (
    <div className="w-40 z-[9]">
      <FilterColumn options={props.langs} label="Filter Bahasa" queryName={name} prefix={name} onChange={handleChange} defaultValue={props.lang} />
    </div>
  )
}

export default LangFilter