import React from 'react'

function RowLabel(props) {
  const { label, value = null, children } = props
  let { valueClassName = '' } = props
  let { labelClassName = 'font-semibold sm:text-lg md:text-base md:font-normal w-full md:w-48 capitalize' } = props
  let { wrapperClassName = 'grid sm:grid-cols-12 w-full sm:gap-4' } = props

  return (
    <div className={wrapperClassName}>
      <p className={"col-span-6 " + labelClassName}>{label}</p>
      {value ? (
        <p className={"col-span-6 " + valueClassName}>{value}</p>
      ) : children}
    </div>
  )
}

export default RowLabel