import { useState } from "react";
import SideNavbar from "@/Components/SideNavbar";
import Sidebar from "@/Components/Sidebar";
import { Head, usePage } from "@inertiajs/react";
import FlashMessage from "@/Components/FlashMessage";

function AuthenticatedLayout({ title, children, auth }) {
  const [open, setOpen] = useState(false);
  const sidebarMenu = useSidebarMenu();

  return (
    <div className="flex">
      <Head title={title} />
      <Sidebar title={title} menu={sidebarMenu} open={open} setOpen={setOpen} />
      <div className={` ${open ? "w-16 sm:block sm:w-full" : "block"} min-h-screen flex-1 bg-white border-l`}>
        <SideNavbar setOpen={setOpen} open={open} title={title} auth={auth} link="/admin/dashboard" />
        <div className={`${open && "hidden md:block"}`}>
          <FlashMessage />
          {children}
        </div>
      </div>
    </div>
  );
}

const useSidebarMenu = () => {
  const { user } = usePage().props.auth;

  let sidebarMenu = [
    {
      title: "Dashboard",
      src: "fas fa-tachometer-alt fa-fw",
      link: "/admin/dashboard",
    },
    {
      title: "Manajemen Pengguna",
      src: "fas fa-users",
      link: "/admin/users"
    },
    {
      title: "Kategori",
      src: "fas fa-layer-group",
      link: "/admin/category",
    },
    {
      title: "Merek",
      src: "fas fa-store",
      link: "/admin/brand",
    },
    {
      title: "Produk",
      src: "fas fa-box-open",
      link: "/admin/product",
    },
    {
      title: "Galeri Proyek",
      src: "fas fa-images",
      link: "/admin/gallery",
    },
    {
      title: "Lowongan Pekerjaan",
      src: "fas fa-briefcase",
      link: "/admin/career",
    },
    {
      title: "Profil Perusahaan",
      src: "fas fa-building",
      link: "/admin/profile",
    },
    {
      title: "Kotak Masuk",
      src: "fas fa-envelope",
      link: "/admin/contact",
    },
    {
      title: "Customer Support",
      src: "fas fa-comments",
      link: "/admin/chat",
    },
    {
      title: "Terjemahan",
      src: "fas fa-language",
      link: "/admin/translation"
    },
    {
      title: "SEO",
      src: "fas fa-globe",
      link: "/admin/seo"
    },
    {
      title: "Homepage",
      src: "fas fa-home",
      dropdown: [
        {
          title: "Banner Slider",
          link: "/admin/banner",
        },
        {
          title: "Unique Selling Point",
          link: "/admin/unique-point",
        },
        {
          title: "Klien",
          link: "/admin/client",
        },
        {
          title: "Testimoni",
          link: "/admin/testimony",
        },
      ],
    },
    {
      title: "Blog",
      src: "fas fa-blog",
      dropdown: [
        {
          title: "Kategori",
          link: "/admin/blog/category",
        },
        {
          title: "Artikel",
          link: "/admin/blog/article",
        },
      ],
    },
    {
      title: "Konfigurasi",
      src: "fas fa-gear",
      link: "/admin/configuration",
    },
  ];

  let routes = []

  if (["editor"].includes(user?.role)) {
    routes = [
      "/admin/dashboard",
      "/admin/category",
      "/admin/brand",
      "/admin/product",
      "/admin/gallery",
      "/admin/career",
      "/admin/profile",
      "/admin/contact",
      "/admin/chat",
      "/admin/translation",
      "/admin/seo",
      "/admin/banner",
      "/admin/unique-point",
      "/admin/client",
      "/admin/testimony",
      "/admin/blog/category",
      "/admin/blog/article",
    ];
  }

  if (routes.length > 0) {
    sidebarMenu = sidebarMenu.filter((menu) => {
      if (!menu.link && !!menu.dropdown) {
        menu.dropdown = menu.dropdown.filter((subMenu) => {
          return routes.includes(subMenu.link);
        });

        return menu.dropdown.length > 0;
      }

      return routes.includes(menu.link);
    });
  }


  return sidebarMenu;
};


export default AuthenticatedLayout;
