import FlashMessage from "@/Components/FlashMessage";
import { Link } from "@inertiajs/react";

export default function Guest({ children }) {
  return (
    <div className="min-h-screen flex flex-col sm:justify-center items-center pt-6 sm:pt-0 bg-gradient-to-t from-[#0C6A93] to-[#0399DB]">
      <div
        className=" absolute inset-0 w-full h-full bg-gradient-to-br from-[#0C6A93] to-[#0399DB] z-0 border-r-6 border-[#0399DB] shadow-2xl"
        style={{
          transform: "skewx(55deg)",
          transformOrigin: "bottom right",
        }}
      >
      </div>
      <div className="absolute top-0 left-0 w-full h-full bg-gradient-to-b from-black to-transparent opacity-60"></div>

      <div className="flex h-full w-full justify-center items-center ">
        <div className=" flex-1 h-screen flex justify-center items-center ">
          <div className="w-full  sm:max-w-md mt-6 px-6 py-4  overflow-hidden sm:rounded-lg h-96  relative flex flex-col gap-20 ">
            <Link
              href="/"
              className="absolute cursor-pointer inline-block hover:scale-120 text-white transition-transform duration-300 ease-in-out"
            >
              <i className="fas fa-arrow-left text-xl"></i>
            </Link>

            {children}
          </div>
        </div>

        <div className="h-screen flex-1 lg:flex lg:flex-col ml-auto py-[25vh] text-right p-4 z-10 hidden relative ">
          <img src="/image/logos/Gamatech_vertical.png" alt="" srcset="" className="w-[30rem] ml-auto bg-white rounded-lg p-4 absolute right-10" />
        </div>


      </div>
      <FlashMessage />
    </div>
  );
}
