import Footer from "@/Components/Footer"
import LogoutModal from "@/Components/LogoutModal"
import { setCookie } from "@/utlis/format"
import useLang from "@/utlis/useLang"
import { Head, Link, router, usePage } from "@inertiajs/react"
import { useEffect, useState } from "react"
import { FaPhoneAlt, FaWhatsapp } from "react-icons/fa"
import "../Pages/User/Home/fonts.css"

import UserChatModal from "@/Components/Default/UserChatModal"
import useButtonTitle from "@/utlis/useButtonTitle"
import FlashMessage from "@/Components/FlashMessage"
function HomeLayout({ Breadcrumb = null, footer = true, children }) {
  const user = usePage().props.auth.user

  const { url, props } = usePage()
  const title = useButtonTitle()

  const [fixed, setFixed] = useState(false)
  const [menuOpen, setMenuOpen] = useState(false)

  const handleScroll = () => {
    if (window.scrollY > 100) {
      setFixed(true)
    } else {
      setFixed(false)
    }
  }

  useEffect(() => {
    handleScroll()
    window.addEventListener("scroll", handleScroll)
    return () => {
      window.removeEventListener("scroll", handleScroll)
    }
  }, [])

  function removeZero(number) {
    number = number.replace(/\D/g, "")

    if (number.startsWith(0)) {
      number = number.slice(1)
    }

    return number
  }

  return (
    <>
      <Head title={props.title} />

      <div className="relative flex flex-col justify-between w-full min-h-screen max-w-screen-3xl mx-auto">
        <div className="flex flex-col items-center">
          <div
            className={`fixed z-50  w-full ${fixed ? "" : "bg-transparent"}transition-all max-w-screen-3xl duration-300 ease-in-out ${fixed ? "text-black " : "text-white"}`}
          >
            <div
              className={`flex  ${fixed ? "backdrop-blur-sm lg:h-20 bg-white shadow-lg lg:bg-opacity-90" : "lg:h-24"} ${menuOpen ? "bg-white" : ""} transition-all  duration-300 justify-between items-center px-5 md:px-20 lg:px-40 w-full`}
            >
              <div>
                <a title={`${title}`} href="/">
                  <img
                    src="/image/logos/Gamatech_square.webp"
                    alt="Logo"
                    width={96}
                    height={96}
                    fetchpriority="high"
                    className="w-16 h-16   md:w-14 md:h-14  lg:w-24 lg:h-24"
                  />
                </a>
              </div>

              <div className="flex items-center gap-2 ">
                {/* Hamburger Button */}

                <div className="lg:hidden ">
                  <LangSelector />
                </div>

                <button
                  aria-label="Navbar"
                  onClick={() => setMenuOpen(!menuOpen)}
                  className={`inline-flex items-center p-2 w-10 h-10 justify-center text-sm  ${fixed || menuOpen ? "text-black " : "text-white"}  rounded-lg lg:hidden  focus:outline-none `}
                >
                  <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 6h16M4 12h16M4 18h16" />
                  </svg>
                </button>

                {/* Desktop Menu */}
                <div className="hidden lg:flex text-xl  md:gap-10">
                  <NavbarMenu fixed={fixed} title={title} />
                </div>
              </div>

              {/* Contact Icons */}
              <div className="lg:flex flex-row justify-center items-center gap-2 hidden">
                <a
                  title={`${title}`}
                  href={`tel:+62${removeZero(props.footer.phone)}`}
                  className="bg-[#E6F5FC] rounded-full w-4 h-4 lg:h-9 lg:w-9 flex items-center justify-center shadow-sm hover:bg-[#c1dae6] cursor-pointer"
                >
                  <FaPhoneAlt className="text-[#0399DB] text-[8px] sm:text-[20px] lg:text-[20px]" />
                </a>
                <a
                  title={`${title}`}
                  href={`https://wa.me/62${removeZero(props.footer.whatsapp)}`}
                  className="bg-[#E6F5FC] rounded-full w-4 h-4 lg:h-9 lg:w-9 flex items-center justify-center shadow-sm hover:bg-[#c1dae6] cursor-pointer"
                >
                  <FaWhatsapp className="text-[#0399DB] text-[10px] sm:text-[20px] lg:text-[25px]" />
                </a>

                <LangSelector />
              </div>
            </div>

            {/* Mobile Menu */}
            {menuOpen && (
              <div
                className="absolute top-full left-0 w-full mt-[-1px] border-white bg-white text-black shadow-md z-40 lg:hidden
               transition-all duration-300 transform opacity-100 translate-y-0
               animate-slideDown"
              >
                <ul className="flex flex-col p-4 space-y-2 items-center">
                  <NavbarMenu fixed={fixed} title={title} />
                </ul>
              </div>
            )}
          </div>

          {/* Content */}
          <div className="w-full mx-auto  ">
            {Breadcrumb ? <Breadcrumb /> : null}
            {children}
          </div>
        </div>

        {footer ? <Footer /> : null}
      </div>
      <UserChatModal />
      <LogoutModal />
      <FlashMessage />
    </>
  )
}

const Auth = () => {
  const user = usePage().props.auth.user
  const picture = user?.picture ? user.picture : `/image/user.png`

  const navbarMenu = [
    {
      title: "Beranda",
      src: "fas fa-2x fa-home",
      link: "/"
    }
  ]

  return user?.role == "user" ? (
    <div className="dropdown dropdown-end">
      <label tabIndex={0} className="btn btn-ghost btn-circle avatar">
        <div className="w-10 normal-case border-2 rounded-full">
          <img src={picture} alt="Account" width={50} />
        </div>
      </label>
      <ul tabIndex={0} className="z-50 p-2 mt-3 shadow dropdown-content bg-base-100 rounded-box w-max">
        <li className="p-4 h-max">
          <div className="flex flex-col items-center justify-center gap-y-6">
            <div className="flex flex-row items-start gap-x-3">
              <div className="avatar">
                <div className="w-10 h-10 border-2 rounded-full">
                  <img src={picture} alt="Account" width={50} />
                </div>
              </div>
              <div className="flex flex-col w-full">
                <div className="font-bold">{user?.name}</div>
                <p className="text-sm">{user?.email}</p>
              </div>
            </div>
            <div className="flex flex-wrap items-center justify-between w-full gap-2">
              {navbarMenu.map((menu, i) => (
                <Link key={i} className="text-gray-700 cursor-pointer hover:text-primary" href={menu.link}>
                  <div className="flex flex-col items-center gap-2">
                    <i className={menu.src}></i>
                    <p className="text-sm">{menu.title}</p>
                  </div>
                </Link>
              ))}
              <a className="text-gray-700 cursor-pointer hover:text-primary" href="#logout-confirm">
                <div className="flex flex-col items-center gap-2">
                  <i className="fas fa-2x fa-sign-out-alt"></i>
                  <p className="text-sm">Logout</p>
                </div>
              </a>
            </div>
          </div>
        </li>
      </ul>
    </div>
  ) : (
    <Link href={"/dashboard"} className="text-white whitespace-pre btn-primary btn btn-sm">
      Dashboard
    </Link>
  )
}

const NavbarMenu = ({ fixed, title }) => {
  const { url } = usePage()
  const currentPath = url

  const links = [
    { href: "/about", label: useLang("navbar.about") },
    { href: "/product", label: useLang("navbar.product") },
    { href: "/after-sales", label: useLang("navbar.after-sales") },
    { href: "/gallery", label: useLang("navbar.gallery") },
    { href: "/contact", label: useLang("navbar.contact") }
  ]

  return (
    <>
      {links.map((link, index) => (
        <a
          title={`${title}`}
          key={index}
          href={link.href}
          className={`transition-all duration-300 p hover:text-[#0399DB] hover:scale-105 ${
            currentPath === link.href && !fixed ? "lg:border-b-[2px] lg:pb-1 text-[#0399DB] lg:text-white font-semibold" : ""
          }
          ${currentPath === link.href && fixed ? "text-[#0399DB] font-semibold" : ""}
          `}
        >
          {link.label}
        </a>
      ))}
    </>
  )
}

const LangSelector = () => {
  const { props } = usePage()

  const [open, setOpen] = useState(false)

  const langOptions = {
    id: "IDN",
    en: "ENG"
  }

  const handleSelectedLang = (value) => {
    setCookie("language", value)
    setOpen(false) // close dropdown
    router.get("?")
  }

  return (
    <div className="relative mx-2">
      <button onClick={() => setOpen(!open)} className="h-10 w-10 lg:pb-1 p flex justify-center items-center gap-1">
        <span>{langOptions[props.locale]}</span>
        <i className={`fas fa-chevron-down transition-transform  duration-300 ${open ? "rotate-180" : "rotate-0"}`}></i>
      </button>

      {open && (
        <ul className="absolute left-0 mt-1 p bg-base-100 rounded-md shadow z-[1] p-2 text-black">
          {Object.entries(langOptions).map(([value, label]) => (
            <li key={value}>
              <button type="button" className="w-full text-left font-medium hover:underline" onClick={() => handleSelectedLang(value)}>
                {label}
              </button>
            </li>
          ))}
        </ul>
      )}
    </div>
  )
}
export default HomeLayout
