import FilePreview from '@/Components/Default/FilePreview';
import FormBuilder from '@/Components/FormBuilder';
import { mimeType, useSearchParams } from '@/utlis/format';
import useFormBuilder from '@/utlis/useFormBuilder';
import useLang from '@/utlis/useLang';

function MainForm({ isEdit = false }) {
  const formConfig = { isEdit, getProperties }
  const builderProps = useFormBuilder(formConfig)

  return (
    <FormBuilder {...builderProps} />
  )
}

const getProperties = (state) => {
  const { setData, props, data } = state
  const { params } = useSearchParams(props.location)

  const properties = [
    // Row 1: Title (ID / EN)
    [
      {
        form: 'textarea',
        props: {
          isTextEditor: true,
          name: 'title_id',
          label: 'Judul (Jika Ada)',
          setData: setData,
          value: data.title_id ?? '',
          alt: useLang('lang.id', state.props),
          height: "100px"
        }
      },
      {
        form: 'textarea',
        props: {
          isTextEditor: true,
          name: 'title_en',
          label: 'Judul (Jika Ada)',
          setData: setData,
          value: data.title_en ?? '',
          alt: useLang('lang.en', state.props),
          height: "100px"
        }
      },
    ],

    // Row 2: DescriptionN)
    [
      {
        form: 'textarea',
        props: {
          isTextEditor: true,
          name: 'description_id',
          label: 'Deskripsi (Jika Ada)',
          setData: setData,
          value: data.description_id ?? '',
          alt: useLang('lang.id', state.props),
          height: "100px"
        }
      },
      {
        form: 'textarea',
        props: {
          isTextEditor: true,
          name: 'description_en',
          label: 'Deskripsi (Jika Ada)',
          setData: setData,
          value: data.description_en ?? '',
          alt: useLang('lang.en', state.props),
          height: "100px"
        }
      }
    ],

    // Row 3: File (image) + Type + Status
    [
      {
        form: 'select',
        props: {
          name: 'type',
          label: 'Tipe Banner',
          options: props.types,
          defaultValue: data.type,
          required: true,
          prefix: 'banner'
        }
      },
      {
        form: 'input',
        props: {
          isDisabled: !data?.type,
          name: 'file',
          label: data?.type == 'video' ? 'Upload Video' : 'Upload Gambar',
          type: 'file',
          accept: data?.type == 'video' ? '.mp4': '.jpg,.jpeg,.png,.avif,.webp',
          required: true,
        },
        infoCard: (property, inputProps) => <FilePreview property={property} inputProps={inputProps} lang='id' />,
      },
    ],

    [
      {
        form: 'checkbox',
        props: {
          name: 'is_action_button',
          label: 'Enable Action Button',
        }
      },
      {
        form: 'input',
        props: {
          isDisabled: !data.is_action_button,
          name: 'action_url',
          label: 'Action URL',
          placeHolder: 'https://gamatech.co.id/product',
        }
      },
      {
        form: 'select',
        props: {
          name: 'status',
          label: 'Status',
          options: props.status,
          defaultValue: data.status,
          required: true,
        }
      }
    ],
  ];
  return properties
}

export default MainForm
