import { Link, usePage } from "@inertiajs/react";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { useState } from "react";
import { ModalButton } from "@/Components/WithModal";
import Table from "@/Components/Table";
import DeleteModal from "@/Components/Modal/DeleteModal";
import { useSearchParams } from "@/utlis/format";
import RestoreModal from "@/Components/Modal/RestoreModal";
import LangFilter from "@/Components/LangFilter";
import DetailModalContent from "@/Components/Default/DetailModalContent";
import DetailModal from "@/Components/Modal/DetailModal";
import RowLabel from "@/Components/RowLabel";

function Index(props) {
  const tableHeader = useTableHeader();
  const filterOptions = useFilterOptions();

  const [show, setShow] = useState(null)
  const handleShow = (data) => {
    setShow(data)
  }

  return (
    <AuthenticatedLayout title={props?.title}>
      <Table search filter
        filterOptions={filterOptions}
        tableHeader={tableHeader}
        headerLeftButton={() => <LangFilter />}
        tableBody={props?.[props?.page?.name]?.data ?? []}
        tablePage={props?.[props?.page?.name]?.links}
        headerButton={() => (
          <>
            <Link href={`${props?.page?.url}/create`} className="btn btn-primary w-max btn-sm text-white">
              Tambah {props?.page?.label}
            </Link>
          </>
        )}
        tableAction={(data) => (
          <>
            <li>
              <ModalButton id={`detail_${data?.id}`} onClick={() => handleShow(data)}>
                <span>Lihat Detail</span>
              </ModalButton>
            </li>
            <li>
              <Link href={`${props?.page?.url}/${data.id}/edit`} className=''>
                Edit
              </Link>
            </li>
            <li>
              <ModalButton id={`modal_delete_${data?.id}`} onClick={() => handleShow(data)}>
                Hapus {data.deleted_at ? 'Permanen' : ''}
              </ModalButton>
            </li>
          </>
        )}
      />

      {show ? (
        <>
          <DeleteModal id={show?.id} label={show.name} isForceDelete={show.deleted_at != null} handleClick={() => handleShow(null)} />
          <DetailModal id={show?.id} tableHeader={tableHeader} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} size='max-w-2xl' />
        </>
      ) : null}
    </AuthenticatedLayout>
  );
}

const useTableHeader = () => {
  const { page, isAdmin, location } = usePage().props
  const { params } = useSearchParams(location)

  const header = [
    {
      label: "#",
      value: "id",
      type: "numbering",
    },
    {
      label: `Bahasa`,
      value: "lang",
      className: 'w-[50px]',
      prefix: 'lang.'
    },
    {
      isDetail: false,
      label: `File`,
      value: "file",
      className: 'w-[250px]',
      custom: ({ data, key, header, defaultClassName }) => {
        const src = data?.file || null;
        const type = data?.type || '';
        return (
          <td key={key} className={`${defaultClassName?.tdBodyClassName} ${header?.className ?? ''} overflow-hidden whitespace-pre`}>
            {src ? (
              type === 'video' ? (
                <video
                  src={src}
                  controls
                  className="w-[200px] h-[120px] object-cover rounded-md border"
                  preload="metadata"
                >
                  Your browser does not support the video tag.
                </video>
              ) : (
                <img
                  src={src}
                  className="w-[200px] h-[120px] object-cover rounded-md border"
                  alt={data?.title || 'preview'}
                />
              )
            ) : (
              <div className="w-[200px] h-[120px] flex items-center justify-center bg-gray-50 border rounded-md text-xs text-gray-400">
                Tidak ada file
              </div>
            )}
          </td>
        )
      }
    },
    {
      isDetail: false,
      label: `Judul`,
      value: "title",
      isSearchable: true,
      custom: ({ data, key, header, defaultClassName }) => {
        return (
          <td key={key} className={`${defaultClassName?.tdBodyClassName} ${header?.className ?? ''} overflow-hidden whitespace-pre max-w-[500px]`}>
            {!!data?.title ? <div className="[&_p]:text-sm [&_p]:text-left [&_p]:leading-tight [&_b]:bg-[#E53134] [&_b]:rounded-sm [&_b]:lg:rounded-2xl [&_b]:px-1 [&_b]:lg:px-4 [&_b]:mx-1 [&_b]:text-white" dangerouslySetInnerHTML={{ __html: data?.title }}></div> : <p>-</p>}
          </td>
        )
      }
    },
    {
      isDetail: false,
      label: `Deskripsi`,
      value: "description",
      isSearchable: true,
      custom: ({ data, key, header, defaultClassName }) => {
        return (
          <td key={key} className={`${defaultClassName?.tdBodyClassName} ${header?.className ?? ''} overflow-hidden whitespace-pre max-w-[500px]`}>
            {!!data?.description ? <div className="[&_p]:text-sm [&_p]:text-left [&_p]:leading-tight" dangerouslySetInnerHTML={{ __html: data?.description }}></div> : <p>-</p>}
          </td>
        )
      }
    },
    {
      isDetail: true,
      label: "Tipe",
      value: "type",
      prefix: "banner.",
    },
    {
      isDetail: true,
      label: `File`,
      value: "file",
      custom: ({ data, key, header, defaultClassName }) => {
        const src = data?.file || null;
        const type = data?.type || '';
        return (
          <td key={key}>
            <RowLabel label={header?.label} wrapperClassName="" >
              {src ? (
                type === 'video' ? (
                  <video
                    src={src}
                    controls
                    className="w-full h-full object-cover rounded-md border"
                    preload="metadata"
                  >
                    Your browser does not support the video tag.
                  </video>
                ) : (
                  <img
                    src={src}
                    className="w-full h-full object-cover rounded-md border"
                    alt={data?.title || 'preview'}
                  />
                )
              ) : (
                <div className="w-[200px] h-[120px] flex items-center justify-center bg-gray-50 border rounded-md text-xs text-gray-400">
                  Tidak ada file
                </div>
              )}
            </RowLabel>
          </td>
        )
      }
    },
    {
      isDetail: true,
      label: `Judul`,
      value: "title",
      isSearchable: true,
      custom: ({ data, key, header, defaultClassName }) => {
        return (
          <td key={key} className={`${defaultClassName?.tdBodyClassName} ${header?.className ?? ''}`}>
            <RowLabel label={header?.label} wrapperClassName="" >
              {!!data?.title ? <div className="[&_p]:text-left [&_p]:leading-tight [&_b]:bg-[#E53134] [&_b]:rounded-sm [&_b]:lg:rounded-2xl [&_b]:px-1 [&_b]:lg:px-4 [&_b]:mx-1 [&_b]:text-white" dangerouslySetInnerHTML={{ __html: data?.title }}></div> : <p>-</p>}
            </RowLabel>
          </td>
        )
      }
    },
    {
      isDetail: true,
      label: `Deskripsi`,
      value: "description",
      isSearchable: true,
      custom: ({ data, key, header, defaultClassName }) => {
        return (
          <td key={key} className={`${defaultClassName?.tdBodyClassName} ${header?.className ?? ''}`}>
            <RowLabel label={header?.label} wrapperClassName="" >
              {!!data?.description ? <div className="[&_p]:text-left [&_p]:leading-tight [&_b]:bg-[#E53134] [&_b]:rounded-sm [&_b]:lg:rounded-2xl [&_b]:px-1 [&_b]:lg:px-4 [&_b]:mx-1 [&_b]:text-white" dangerouslySetInnerHTML={{ __html: data?.description }}></div> : <p>-</p>}
            </RowLabel>
          </td>
        )
      }
    },
    {
      isDetail: true,
      label: "Enable Action Button",
      value: "is_action_button",
      type: "boolean"
    },
    {
      isDetail: true,
      label: "Action Button",
      value: "action_url",
      defaultValue: "-"
    },
    {
      label: "Status",
      value: "status",
      type: "status",
      className: 'w-[10%]',
    },
    {
      label: "Dibuat",
      value: "created_at",
      type: "date",
      isSearchable: true,
      className: 'w-[10%]',
    },
    {
      label: "Diperbarui",
      value: "updated_at",
      type: "date",
      isSearchable: true,
      className: 'w-[10%]',
    },
    {
      label: "Aksi",
      value: "id",
      type: "action",
      className: 'w-[10%]',
    },
  ];


  return header;
};

const useFilterOptions = () => {
  const { props } = usePage()
  const filterOptions = [
    {
      name: 'status',
      data: props?.status,
      label: 'Filter Status',
    },
  ]

  return filterOptions
};

export default Index;
