import { Link, usePage } from "@inertiajs/react";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { useState } from "react";
import { ModalButton } from "@/Components/WithModal";
import Table from "@/Components/Table";
import DeleteModal from "@/Components/Modal/DeleteModal";
import { useSearchParams } from "@/utlis/format";
import LangFilter from "@/Components/LangFilter";
import DetailModal from "@/Components/Modal/DetailModal";
import DetailModalContent from "@/Components/Default/DetailModalContent";

function Index(props) {
  const tableHeader = useTableHeader();
  const filterOptions = useFilterOptions();

  const [show, setShow] = useState(null)
  const handleShow = (data) => {
    setShow(data)
  }

  return (
    <AuthenticatedLayout title={props?.title}>
      <Table search filter
        filterOptions={filterOptions}
        tableHeader={tableHeader}
        headerLeftButton={() => <LangFilter />}
        tableBody={props?.[props?.page?.name]?.data ?? []}
        tablePage={props?.[props?.page?.name]?.links}
        headerButton={() => (
          <>
            <Link href={`${props?.page?.url}/create`} className="btn btn-primary w-max btn-sm text-white">
              Tambah {props?.page?.label}
            </Link>
          </>
        )}
        tableAction={(data) => (
          <>
            <li>
              <ModalButton id={`detail_${data?.id}`} onClick={() => handleShow(data)}>
                <span>Lihat Detail</span>
              </ModalButton>
            </li>
            <li>
              <Link href={`${props?.page?.url}/${data.id}/edit`} className=''>
                Edit
              </Link>
            </li>
            <li>
              <ModalButton id={`modal_delete_${data?.id}`} onClick={() => handleShow(data)}>
                Hapus
              </ModalButton>
            </li>
          </>
        )}
      />

      {show ? (
        <>
          <DeleteModal id={show?.id} label={show.name} isForceDelete={show.deleted_at != null} handleClick={() => handleShow(null)} />
          <DetailModal id={show?.id} tableHeader={tableHeader} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} size='max-w-5xl' />
        </>
      ) : null}
    </AuthenticatedLayout>
  );
}

const useTableHeader = () => {
  const { page, isAdmin, location } = usePage().props
  const { params } = useSearchParams(location)

  const header = [
    {
      label: "#",
      value: "id",
      type: "numbering",
    },
    {
      label: `Bahasa`,
      value: "lang",
      className: 'w-[50px]',
      prefix: 'lang.'
    },
    {
      label: `Judul ${page?.label}`,
      value: "title",
      className: 'w-[200px]',
      isSearchable: true,
    },
    {
      label: `Kategori`,
      value: "category.name",
      className: 'w-[200px]',
      isSearchable: true,
    },
    {
      label: "Status",
      value: "status",
      type: "status",
      className: 'w-[10%]',
    },
    {
      label: "Diterbitkan",
      value: "published_at",
      type: "date",
      isSearchable: true,
      className: 'w-[10%]',
      defaultValue: '-'
    },
    {
      label: "Dibuat",
      value: "created_at",
      type: "date",
      isSearchable: true,
      className: 'w-[10%]',
    },
    {
      label: "Diperbarui",
      value: "updated_at",
      type: "date",
      isSearchable: true,
      className: 'w-[10%]',
    },
    {
      label: "Aksi",
      value: "id",
      type: "action",
      className: 'w-[10%]',
    },
    {
      isDetail:true,
      label: "SEO Keyword",
      value: "keyword",
      className: 'w-[10%]',
      wrapperClassName:"flex flex-col",
      defaultValue: '-'
    },
    {
      isDetail:true,
      label: "SEO Deskripsi",
      value: "short_description",
      wrapperClassName:"flex flex-col",
      className: 'w-[10%]',
      defaultValue: '-'
    },
    {
      isDetail:true,
      label: "Konten",
      value: "description",
      wrapperClassName: "flex flex-col max-w-[85vw] overflow-auto",
      type: "html",
      defaultValue: '-'
    },
  ];

  return header;
};

const useFilterOptions = () => {
  const { props } = usePage()
  const filterOptions = [
    {
      name: 'status',
      data: props?.status,
      label: 'Filter Status',
    },
  ]

  return filterOptions
};

export default Index;
