import FormBuilder from '@/Components/FormBuilder';
import { mimeType, slugify, useSearchParams } from '@/utlis/format';
import useFormBuilder from '@/utlis/useFormBuilder';
import { useEffect } from 'react';

function MainForm({ isEdit = false }) {
  const formConfig = { isEdit, getProperties }
  const builderProps = useFormBuilder(formConfig)

  const { data, setData } = builderProps.form

  useEffect(() => {
      let filteredSlug = ''
      if (data.name && !isEdit) {
        const slug = slugify(data.name)
        filteredSlug = `${slug}`
      }
  
      if (!isEdit) {
        setData('slug', filteredSlug)
      }
  
    }, [data.name])

  return (
    <FormBuilder {...builderProps} />
  )
}

const getProperties = (state) => {
  const { setData, props, data } = state
  const { params } = useSearchParams(props.location)

  const properties = [
    [
      {
        form: 'input',
        props: {
          name: 'name',
          label: 'Nama',
          type: 'text',
        },
      },
      // {
      //   form: 'input',
      //   props: {
      //     name: 'slug',
      //     label: 'Slug',
      //     type: 'text',
      //   }
      // },
    ],
    [
      {
        form: 'input',
        imagePreview: true,
        isSidePreview: false,
        previewLabel: 'Preview:',
        previewClassName: "w-[160px] h-[160px] object-cover border rounded-md",
        props: {
          name: 'image',
          label: 'Gambar',
          type: 'file',
          accept: mimeType('image'),
        },
      },
      {
        form: 'select',
        props: {
          name: 'status',
          label: 'Status',
          options: props.status,
          defaultValue: data.status,
        }
      },
    ]
  ]

  return properties
}
export default MainForm
