import FormBuilder from '@/Components/FormBuilder';
import { slugify, useSearchParams } from '@/utlis/format';
import useFormBuilder from '@/utlis/useFormBuilder';
import useLang from '@/utlis/useLang';
import { usePage } from '@inertiajs/react';
import { useEffect } from 'react';

function MainForm({ isEdit = false }) {
  const { page } = usePage().props

  const formConfig = { isEdit, getProperties }
  const builderProps = useFormBuilder(formConfig)
  const { data, setData } = builderProps.form

  useEffect(() => {
    let filteredSlug = ''
    if (data.title_id && !isEdit) {
      const slug = slugify(data.title_id)
      filteredSlug = `${slug}`
    }

  if (!isEdit) {
      setData('slug_id', filteredSlug)
    }

  }, [data.title_id])

  useEffect(() => {
    let filteredSlug = ''
    if (data.title_en && !isEdit) {
      const slug = slugify(data.title_en)
      filteredSlug = `${slug}`
    }

    if (!isEdit) {
      setData('slug_en', filteredSlug)
    }
  }, [data.title_en])

  return (
    <FormBuilder {...builderProps} />
  )
}

const getProperties = (state) => {
  const { setData, props, data, errors } = state
  const { params } = useSearchParams(props.location)

  const properties = [
    [
      {
        form: 'input',
        props: {
          name: 'title_id',
          label: `Judul ${props.page?.label}`,
          type: 'text',
          alt: useLang('lang.id', state.props)
        }
      },
      {
        form: 'input',
        props: {
          name: 'title_en',
          label: `Judul ${props.page?.label}`,
          type: 'text',
          alt: useLang('lang.en', state.props)
        }
      },
    ],
    // [
    //   {
    //     form: 'input',
    //     props: {
    //       name: 'slug_id',
    //       label: 'Slug',
    //       type: 'text',
    //       alt: useLang('lang.id', state.props)
    //     }
    //   },
    //   {
    //     form: 'input',
    //     props: {
    //       name: 'slug_en',
    //       label: 'Slug',
    //       type: 'text',
    //       alt: useLang('lang.en', state.props)
    //     }
    //   },
    // ],
    [
      {
        form: 'textarea',
        props: {
          name: 'description_id',
          label: 'Deskripsi Singkat',
          setData: setData,
          alt: useLang('lang.id', state.props)
        }
      },
      {
        form: 'textarea',
        props: {
          name: 'description_en',
          label: 'Deskripsi Singkat',
          setData: setData,
          alt: useLang('lang.en', state.props)
        }
      },
    ],
    [
      {
        form: 'textarea',
        props: {
          isTextEditor: true,
          name: 'qualification_id',
          label: 'Kualifikasi',
          setData: setData,
          alt: useLang('lang.id', state.props)
        }
      },
      {
        form: 'textarea',
        props: {
          isTextEditor: true,
          name: 'qualification_en',
          label: 'Kualifikasi',
          setData: setData,
        alt: useLang('lang.en', state.props)
        }
      },
    ],
    [
      {
        form: 'input',
        props: {
          name: 'location',
          label: 'Lokasi',
          type: 'text',
        }
      },
      {
        form: 'input',
        props: {
          name: 'email',
          label: 'Email',
          type: 'email',
        }
      },
      {
        form: 'select',
        props: {
          name: 'status',
          label: 'Status',
          options: props.status,
          defaultValue: data.status,
        }
      },
      {
        form: 'input',
        isHidden: data.status != 'publish',
        props: {
          name: 'published_at',
          label: 'Waktu Publikasi',
          type: 'datetime-local',
        }
      },
    ]
  ]

  return properties
}
export default MainForm
