import SEOQuality from '@/Components/Default/SEOQuality';
import FormBuilder from '@/Components/FormBuilder';
import { mimeType, slugify, useSearchParams } from '@/utlis/format';
import useFormBuilder from '@/utlis/useFormBuilder';
import useLang from '@/utlis/useLang';
import { useEffect } from 'react';

function MainForm({ isEdit = false }) {
  const formConfig = { isEdit, getProperties }
  const builderProps = useFormBuilder(formConfig)

  const { data, setData } = builderProps.form

  useEffect(() => {
    let filteredSlug = ''
    if (data.name_id && !isEdit) {
      const slug = slugify(data.name_id)
      filteredSlug = `${slug}`
    }

    if (!isEdit) {
      setData('slug_id', filteredSlug)
    }

  }, [data.name_id])

  useEffect(() => {
    let filteredSlug = ''
    if (data.name_en && !isEdit) {
      const slug = slugify(data.name_en)
      filteredSlug = `${slug}`
    }

    if (!isEdit) {
      setData('slug_en', filteredSlug)
    }
  }, [data.name_en])

  useEffect(() => {
    const desc = data?.seo_description_id

    if (desc && desc.length > 160) {
      const truncated = desc.substring(0, 160)
      if (desc !== truncated) {
        setData('seo_description_id', truncated)
      }
    }
  }, [data?.seo_description_id])

  useEffect(() => {
    const desc = data?.seo_description_en

    if (desc && desc.length > 160) {
      const truncated = desc.substring(0, 160)
      if (desc !== truncated) {
        setData('seo_description_en', truncated)
      }
    }
  }, [data?.seo_description_en])

  return (
    <FormBuilder {...builderProps} />
  )
}

const getProperties = (state) => {
  const { setData, props, data } = state
  const { params } = useSearchParams(props.location)

  const properties = [
    [
      {
        form: 'select',
        props: {
          name: 'type',
          label: 'Jenis Kategori',
          options: props.types,
          prefix: 'category'
        }
      },
    ],
    [
      {
        form: 'input',
        props: {
          name: 'name_id',
          label: 'Nama Kategori',
          type: 'text',
          alt: useLang('lang.id', state.props)
        }
      },
      {
        form: 'input',
        props: {
          name: 'name_en',
          label: 'Nama Kategori',
          type: 'text',
          alt: useLang('lang.en', state.props)
        }
      },
    ],
    [
      {
        form: 'input',
        isHidden: data.type == 'after-sales',
        props: {
          name: 'slug_id',
          label: 'Slug',
          type: 'text',
          alt: useLang('lang.id', state.props)
        }
      },
      {
        form: 'input',
        isHidden: data.type == 'after-sales',
        props: {
          name: 'slug_en',
          label: 'Slug',
          type: 'text',
          alt: useLang('lang.en', state.props)
        }
      },
    ],
    [
      {
        form: 'textarea',
        props: {
          isTextEditor: true,
          name: 'description_id',
          label: 'Deskripsi',
          setData: setData,
          alt: useLang('lang.id', state.props)
        }
      },
      {
        form: 'textarea',
        props: {
          isTextEditor: true,
          name: 'description_en',
          label: 'Deskripsi',
          setData: setData,
          alt: useLang('lang.en', state.props)
        }
      },
    ],
    [
      {
        form: 'textarea',
        props: {
          name: 'seo_description_id',
          label: 'SEO Deskripsi',
          setData: setData,
          alt: useLang('lang.id', state.props),
          bottomLabel: 'Maksimal 160 Karakter'
        }
      },
      {
        form: 'textarea',
        props: {
          name: 'seo_description_en',
          label: 'SEO Deskripsi',
          setData: setData,
          alt: useLang('lang.en', state.props),
          bottomLabel: 'Maksimal 160 Karakter'
        }
      },
    ],
    [
      {
        form: 'textarea',
        props: {
          name: 'seo_keyword_id',
          label: 'SEO Keyword',
          setData: setData,
          alt: useLang('lang.id', state.props),
          placeHolder: 'tips dan trik, panduan',
          bottomLabel: 'Pisahkan dengan koma'
        },
        infoCard: (property, inputProps) => <SEOQuality property={property} inputProps={inputProps} lang='id' />
      },
      {
        form: 'textarea',
        props: {
          name: 'seo_keyword_en',
          label: 'SEO Keyword',
          setData: setData,
          alt: useLang('lang.en', state.props),
          placeHolder: 'tips and tricks, guide',
          bottomLabel: 'Pisahkan dengan koma'
        },
        infoCard: (property, inputProps) => <SEOQuality property={property} inputProps={inputProps} lang='en' />
      },
    ],
    [
      {
        form: 'input',
        imagePreview: true,
        isSidePreview: false,
        previewLabel: 'Preview:',
        previewClassName: "w-[160px] h-[160px] object-cover border rounded-md",
        props: {
          name: 'thumbnail',
          label: 'Gambar',
          type: 'file',
          accept: mimeType('image'),
        },
      },
      {
        form: 'select',
        props: {
          name: 'status',
          label: 'Status',
          options: props.status,
          defaultValue: data.status,
        }
      },
    ]
  ]

  return properties
}
export default MainForm
