import { Link, usePage } from "@inertiajs/react";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { useState } from "react";
import { ModalButton } from "@/Components/WithModal";
import Table from "@/Components/Table";
import DeleteModal from "@/Components/Modal/DeleteModal";
import { useSearchParams } from "@/utlis/format";
import RestoreModal from "@/Components/Modal/RestoreModal";
import LangFilter from "@/Components/LangFilter";
import DetailModalContent from "@/Components/Default/DetailModalContent";
import DetailModal from "@/Components/Modal/DetailModal";

function Index(props) {
  const tableHeader = useTableHeader();
  const filterOptions = useFilterOptions();

  const [show, setShow] = useState(null)
  const handleShow = (data) => {
    setShow(data)
  }

  return (
    <AuthenticatedLayout title={props?.title}>
      <Table search filter
        filterOptions={filterOptions}
        tableHeader={tableHeader}
        headerLeftButton={() => <LangFilter />}
        tableBody={props?.[props?.page?.name]?.data ?? []}
        tablePage={props?.[props?.page?.name]?.links}
        headerButton={() => (
          <>
            <Link href={`${props?.page?.url}/create`} className="btn btn-primary w-max btn-sm text-white">
              Tambah {props?.page?.label}
            </Link>
          </>
        )}
        tableAction={(data) => (
          <>
            <li>
              <ModalButton id={`detail_${data?.id}`} onClick={() => handleShow(data)}>
                <span>Lihat Detail</span>
              </ModalButton>
            </li>
            {data.deleted_at ? (
              <li>
                <ModalButton id={`modal_restore_${data?.id}`} onClick={() => handleShow(data)}>
                  Pulihkan Data
                </ModalButton>
              </li>
            ) : (
              <li>
                <Link href={`${props?.page?.url}/${data.id}/edit`} className=''>
                  Edit
                </Link>
              </li>
            )}
            <li>
              <ModalButton id={`modal_delete_${data?.id}`} onClick={() => handleShow(data)}>
                Hapus {data.deleted_at ? 'Permanen' : ''}
              </ModalButton>
            </li>
          </>
        )}
      />

      {show ? (
        <>
          <DeleteModal id={show?.id} label={show.name} isForceDelete={show.deleted_at != null} handleClick={() => handleShow(null)} />
          <RestoreModal id={show?.id} label={show.name} handleClick={() => handleShow(null)} />
          <DetailModal id={show?.id} tableHeader={tableHeader} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} size='max-w-5xl' />
        </>
      ) : null}
    </AuthenticatedLayout>
  );
}

const useTableHeader = () => {
  const { page, isAdmin, location } = usePage().props
  const { params } = useSearchParams(location)

  const header = [
    {
      label: "#",
      value: "id",
      type: "numbering",
    },
    {
      label: `Bahasa`,
      value: "lang",
      className: 'w-[50px]',
      prefix: 'lang.'
    },
    {
      label: `Nama ${page?.label}`,
      value: "name",
      className: 'w-[200px]',
      isSearchable: true,
    },
    {
      label: `Jenis`,
      value: "type",
      className: 'w-[50px]',
      prefix: 'category.'
    },
    {
      label: `Deskripsi`,
      value: "description",
      isSearchable: true,
      custom: ({ data, key, header, defaultClassName }) => {
        return (
          <td key={key} className={`${defaultClassName?.tdBodyClassName} ${header?.className ?? ''} overflow-hidden whitespace-pre max-w-[500px]`}>
            <div className="text-editor-content" dangerouslySetInnerHTML={{ __html: data?.description }}></div>
          </td>
        )
      }
    },
    {
      label: "Status",
      value: "status",
      type: "status",
      className: 'w-[10%]',
    },
    {
      label: "Dibuat",
      value: "created_at",
      type: "date",
      isSearchable: true,
      className: 'w-[10%]',
    },
    {
      label: "Diperbarui",
      value: "updated_at",
      type: "date",
      isSearchable: true,
      className: 'w-[10%]',
    },
    {
      label: "Dihapus",
      value: "deleted_at",
      type: "date",
      className: 'w-[10%]',
      isHidden: params.get('deleted_at') != 'show'
    },
    {
      label: "Aksi",
      value: "id",
      type: "action",
      className: 'w-[10%]',
    },
    {
      isDetail: true,
      label: "Gambar",
      value: "thumbnail",
      type: "image",
      className: 'border p-4 rounded-md',
      wrapperClassName: "flex flex-col",
      defaultValue: '-'
    },
    {
      isDetail: true,
      label: "SEO Keyword",
      value: "seo_keyword",
      className: 'w-[10%]',
      wrapperClassName: "flex flex-col",
      defaultValue: '-'
    },
    {
      isDetail: true,
      label: "SEO Deskripsi",
      value: "seo_description",
      wrapperClassName: "flex flex-col",
      className: 'w-[10%]',
      defaultValue: '-'
    },
    {
      isDetail: true,
      label: "Konten",
      value: "description",
      wrapperClassName: "flex flex-col max-w-[85vw] overflow-auto",
      type: "html",
      defaultValue: '-'
    },
  ];

  return header;
};

const useFilterOptions = () => {
  const { props } = usePage()
  const filterOptions = [
    {
      name: 'status',
      data: props?.status,
      label: 'Filter Status',
    },
    {
      name: 'deleted_at',
      label: 'Filter Data Terhapus',
    },
  ]

  return filterOptions
};

export default Index;
