import { usePage } from "@inertiajs/react";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { useState } from "react";
import { ModalButton } from "@/Components/WithModal";
import Table from "@/Components/Table";
import { useSearchParams } from "@/utlis/format";
import DetailModal from "@/Components/Modal/DetailModal";
import DetailModalContent from "@/Components/Default/DetailModalContent";
import UpdateStatusModal from "./Modal/UpdateStatusModal";
import ChatModal from "./Modal/ChatModal";

function Index(props) {
  const tableHeader = useTableHeader();
  const filterOptions = useFilterOptions();

  const [show, setShow] = useState(null)
  const [status, setStatus] = useState(null)
  const [showIndex, setShowIndex] = useState(-1)

  const handleShow = (data, status = null) => {
    setShow(data)
    setStatus(status)

    let index = null
    if (data) {
      index = props?.[props?.page?.name]?.data?.findIndex((pageData) => pageData.id == data?.id)
    }
    if (index > -1) {
      setShowIndex(index)
    }

  }

  return (
    <AuthenticatedLayout title={props?.title}>
      <Table search filter
        filterOptions={filterOptions}
        tableHeader={tableHeader}
        tableBody={props?.[props?.page?.name]?.data ?? []}
        tablePage={props?.[props?.page?.name]?.links}
        tableAction={(data) => (
          <>
            <li>
              <ModalButton id={`detail_${data?.id}`} onClick={() => handleShow(data)}>
                <span>Lihat Detail</span>
              </ModalButton>
            </li>
            <li>
              <ModalButton id={`chat_${data?.id}`} onClick={() => handleShow(data)}>
                Lihat Percakapan
              </ModalButton>
            </li>
            <li>
              <ModalButton id={`update_status_${data?.id}`} onClick={() => handleShow(data, 'new')}>
                <span>Tandai Belum Dibaca</span>
              </ModalButton>
            </li>
            <li>
              <ModalButton disabled={data?.status != 'open'} id={`update_status_${data?.id}`} onClick={() => handleShow(data, 'close')}>
                <span>Tutup Percakapan</span>
              </ModalButton>
            </li>
          </>
        )}
      />

      {show ? (
        <>
          <ChatModal id={show?.id} data={show} chats={showIndex > -1 ? props?.[props?.page?.name]?.data?.[showIndex]?.message : show?.message} handleClick={() => handleShow(null)} />
          <DetailModal id={show?.id} tableHeader={tableHeader} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} size='max-w-xl' />
          <UpdateStatusModal id={show?.id} status={status} tableHeader={tableHeader} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} size='max-w-5xl' />
        </>
      ) : null}
    </AuthenticatedLayout>
  );
}

const useTableHeader = () => {
  const { page, isAdmin, location } = usePage().props
  const { params } = useSearchParams(location)

  const header = [
    {
      label: "#",
      value: "id",
      type: "numbering",
    },
    {
      label: `Nama`,
      value: "name",
      isSearchable: true,
      className: 'w-[100px]'
    },
    {
      label: "Jumlah Pesan",
      value: "message_count",
      type: "text",
      className: 'w-[10px]',
      defaultValue: '-',
      valueLabel: "[value] Pesan"
    },
    {
      label: "Status",
      value: "status",
      type: "status",
      className: 'w-[10px]',
      prefix: 'chat.'
    },
    {
      label: "Dikirim",
      value: "created_at",
      type: "date",
      isSearchable: true,
      className: 'w-[100px] !p-0 !whitespace-pre',
    },
    {
      label: "Diperbarui",
      value: "updated_at",
      type: "date",
      isSearchable: true,
      className: 'w-[100px] !p-0 !whitespace-pre',
    },
    {
      label: "Aksi",
      value: "id",
      type: "action",
      className: 'w-[10px] !p-0 !whitespace-pre',
    },
  ];

  return header;
};

const useFilterOptions = () => {
  const { props } = usePage()
  const filterOptions = [
    {
      name: 'status',
      data: props?.status,
      label: 'Filter Status',
      prefix: 'chat'
    },
  ]

  return filterOptions
};

export default Index;
