import TextArea from '@/Components/Form/TextArea'
import WithModal from '@/Components/WithModal'
import { router, useForm, usePage } from '@inertiajs/react'
import { useRef, useState } from 'react'
import { dateHumanize } from '@/utlis/format'
import { useEffect } from 'react'
import FileUploaderInput from '@/Components/Form/FileUploaderInput'
import ImageGallery from "react-image-gallery";
import "react-image-gallery/styles/css/image-gallery.css";

const ChatModal = (state) => {
  const { auth } = usePage().props
  const { data: chat, chats, handleClick } = state
  const MODAL_TYPE = `chat_${chat?.id}`
  const backButtonRef = useRef()
  const bottomRef = useRef(null);

  const [attachment, setAttachment] = useState(false)
  const [isFullScreen, setIsFullScreen] = useState(false)
  const { data, setData, post, errors, processing } = useForm({
    chat_id: chat?.id,
    ref: 'backoffice',
    message: '',
    attachment: '',
  })

  function handleChange(e) {
    const { name, value } = e.target

    setData((state) => ({
      ...state,
      [name]: value
    }))
  }

  useEffect(() => {
    bottomRef.current?.scrollIntoView({ behavior: "smooth" });
    return () => { }
  }, [])

  useEffect(() => {
		let intervalId    
		if (['open','new'].includes(chat?.status)) {
			intervalId = setInterval(() => {
				fetch(`/chat/${chat.id}/status`)
					.then((res) => res.json())
					.then((res) => {
            let latestMessage = res?.data?.chat?.message?.slice(-1)[0]      
            let currentLatestMessage = chat?.message?.slice(-1)[0]
                  
						if (res?.data?.is_new || latestMessage?.id != currentLatestMessage?.id) {
							router.reload({ only: ['chat'], async: false, onSuccess: () => (
                bottomRef.current?.scrollIntoView({ behavior: "smooth" })
              )})
						}
					})
					.catch(function (error) {
						console.log(error)
					})
			}, 5000)
		}

		return () => intervalId ? clearInterval(intervalId) : null
	}, [chat?.id, chat?.status])

  const handleSubmit = (e) => {
    e.preventDefault()
    post(`/chat`, {
      onSuccess: () => {
        setData(state => ({
          ...state,
          ['message']: '',
          ['attachment']: '',
        }))
        setAttachment(false)
        router.reload({ only: ['chat'], async: false, onSuccess: () => (
          bottomRef.current?.scrollIntoView({ behavior: "smooth" })
        ) })
      }
    })
  }

  const inputProps = { handleChange, data, errors }

  return (
    <WithModal type={MODAL_TYPE} backdrop={true} onClick={handleClick} modalBoxSize='max-w-xl'>
      <form action=''>
        <p className='font-semibold text-lg'>Percakapan {chat?.name}</p>
        <div className={`h-full overflow-auto ${attachment ? 'max-h-[40vh]' : 'max-h-[50vh]'}`}>
          {chats.map((chat, index) => {
            const images = chat.image_attachment?.map((attachment) => ({
              original: attachment?.value,
              thumbnail: attachment?.value,
              originalClass: `w-full p-4 object-cover ${isFullScreen ? '' : 'max-h-[300px]'}`
            }))

            const galleryOptions = {
              showThumbnails: false,
              showBullets: true,
              showFullscreenButton: true,
              showPlayButton: false,
              onScreenChange: (fullscreen) => setIsFullScreen(fullscreen)
            }

            return (
              <div key={index} className={`p-2 my-2 rounded-lg ${chat?.user_id == auth?.user?.id ? "text-right bg-green-100" : "text-left bg-white"}`}>
                {images.length > 0 ? <ImageGallery items={images} {...galleryOptions} /> : null}
                {chat.other_attachment?.length > 0 ? (
                  <div className='mt-1 mb-2'>
                    {chat.other_attachment.sort((a, b) => b.type.localeCompare(a.type)).map((attachment, index) => (
                      <a key={index} href={attachment.value} target='_blank' className="whitespace-pre overflow-auto scrollbar-none text-sm link-hover">
                        <div className="">
                          <i className='fas fa-download mr-2'></i>
                          {attachment?.type == 'file' ? attachment?.label : (
                            <span>Buka Link</span>
                          )}
                        </div>
                      </a>
                    ))}
                  </div>
                ) : null}
                <p>{chat.message}</p>

                <div className="">
                  <p className="text-xs text-gray-500">{dateHumanize(chat.created_at)}</p>
                </div>
                {index + 1 >= chats?.length ? (
                  <div ref={bottomRef} />
                ) : null}
              </div>
            )
          })}
        </div>
        {chat.status != 'close' ? (
          <div className='w-full relative flex flex-col gap-1'>
            <TextArea name='message' placeHolder='Tulis pesanmu disini' isLabel={false} {...inputProps} />
            <button type='button' onClick={() => setAttachment((state) => !state)} className={`btn btn-sm ml-auto z-1 -mt-10 mb-2`}>
              <i className={`fas fa-paperclip ${attachment ? 'text-blue-600' : ''}`}></i>
            </button>
            {attachment ? (
              <div className="text-xs max-h-[150px] overflow-auto">
                <FileUploaderInput {...inputProps}
                  {...{
                    name: 'attachment',
                    isLabel: false,
                    accept: ['image', 'pdf'],
                    setData: setData
                  }} />
              </div>
            ) : null}
          </div>
        ) : null}

        <div className='modal-action'>
          <label ref={backButtonRef} onClick={handleClick} htmlFor={`modal_${MODAL_TYPE}`} className='btn btn-sm btn-neutral btn-outline'>
            Kembali
          </label>
          {chat.status != 'close' ? (
            <button onClick={handleSubmit} className={`btn btn-sm btn-neutral`} disabled={processing} >
              <span className={`${processing && 'loading'}`}>
                Kirim
              </span>
            </button>
          ) : null}
        </div>
      </form>
    </WithModal>
  )
}

export default ChatModal
