import { usePage } from "@inertiajs/react";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { useState } from "react";
import { ModalButton } from "@/Components/WithModal";
import Table from "@/Components/Table";
import { useSearchParams } from "@/utlis/format";
import DetailModal from "@/Components/Modal/DetailModal";
import DetailModalContent from "@/Components/Default/DetailModalContent";
import UpdateStatusModal from "./Modal/UpdateStatusModal";

function Index(props) {
  const tableHeader = useTableHeader();
  const filterOptions = useFilterOptions();

  const [show, setShow] = useState(null)
  const [status, setStatus] = useState(null)
  const handleShow = (data, status = null) => {
    setShow(data)
    setStatus(status)
  }

  return (
    <AuthenticatedLayout title={props?.title}>
      <Table search filter
        filterOptions={filterOptions}
        tableHeader={tableHeader}
        tableBody={props?.[props?.page?.name]?.data ?? []}
        tablePage={props?.[props?.page?.name]?.links}
        tableAction={(data) => (
          <>
            <li>
              <ModalButton id={`detail_${data?.id}`} onClick={() => handleShow(data)}>
                <span>Lihat Detail</span>
              </ModalButton>
            </li>
            <li>
              <a href={`mailto:${data?.email}`} target="_blank">
                <span>Kirim Email</span>
              </a>
            </li>
            <li>
              <ModalButton id={`update_status_${data?.id}`} onClick={() => handleShow(data,'process')}>
                <span>Tandai Sedang Diproses</span>
              </ModalButton>
            </li>
            <li>
              <ModalButton id={`update_status_${data?.id}`} onClick={() => handleShow(data,'finish')}>
                <span>Tandai Telah Selesai</span>
              </ModalButton>
            </li>
            <li>
              <ModalButton id={`update_status_${data?.id}`} onClick={() => handleShow(data,'cancel')}>
                <span>Tandai Dibatalkan</span>
              </ModalButton>
            </li>
            <li>
              <ModalButton id={`update_status_${data?.id}`} onClick={() => handleShow(data,'new')}>
                <span>Tandai Belum Dibaca</span>
              </ModalButton>
            </li>
          </>
        )}
      />

      {show ? (
        <>
          <DetailModal id={show?.id} tableHeader={tableHeader} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} size='max-w-xl' />
          <UpdateStatusModal id={show?.id} status={status} tableHeader={tableHeader} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} size='max-w-5xl' />
        </>
      ) : null}
    </AuthenticatedLayout>
  );
}

const useTableHeader = () => {
  const { page, isAdmin, location } = usePage().props
  const { params } = useSearchParams(location)

  const header = [
    {
      label: "#",
      value: "id",
      type: "numbering",
    },
    {
      label: `Kebutuhan`,
      value: "category.name",
      isSearchable: true,
      className:'w-[100px]'
    },
    {
      label: `Nama`,
      value: "name",
      isSearchable: true,
      className:'w-[100px]'
    },
    {
      label: `HP`,
      value: "phone",
      isSearchable: true,
      className:'w-[80px] !px-0'
    },
    {
      label: `Email`,
      value: "email",
      isSearchable: true,
      className:'w-[50px] !px-0'
    },
    {
      label: `Perusahaan`,
      value: "company_name",
      isSearchable: true,
      className:'w-[100px] !px-0'
    },
    {
      label: `Kapasitas`,
      value: "capacity",
      isSearchable: true,
      className:'w-[50px]'
    },
    {
      label: `Proyek`,
      value: "project_name",
      isSearchable: true,
      className:'w-[150px] !px-0'
    },
    {
      label: `Lokasi`,
      value: "location",
      isSearchable: true,
      className:'w-[100px]'
    },
    {
      label: "Status",
      value: "status",
      type: "status",
      className: 'w-[10px]',
      prefix:'contact.'
    },
    {
      label: "Dikirim",
      value: "created_at",
      type: "date",
      isSearchable: true,
      className: 'w-[100px] !p-0 !whitespace-pre',
    },
    {
      label: "Diperbarui",
      value: "updated_at",
      type: "date",
      isSearchable: true,
      className: 'w-[100px] !p-0 !whitespace-pre',
    },
    {
      label: "Aksi",
      value: "id",
      type: "action",
      className: 'w-[10px] !p-0 !whitespace-pre',
    },
  ];

  return header;
};

const useFilterOptions = () => {
  const { props } = usePage()
  const filterOptions = [
    {
      name: 'status',
      data: props?.status,
      label: 'Filter Status',
      prefix: 'contact'
    },
  ]

  return filterOptions
};

export default Index;
