import WithModal from '@/Components/WithModal'
import useLang from '@/utlis/useLang'
import useStatus from '@/utlis/useStatus'
import { useForm, usePage } from '@inertiajs/react'
import { useRef } from 'react'

const UpdateStatusModal = (state) => {
  const { id, data = null, status, isLabel = true, content = null, handleClick } = state
  const MODAL_TYPE = `update_status_${id}`
  const { page } = usePage().props

  const backButtonRef = useRef()
  const { put, processing } = useForm({
    status,
  })

  const handleSubmit = (e) => {
    e.preventDefault()
    put(`${page.url}/${id}`, {
      onSuccess: () => {
        backButtonRef.current?.click()
      }
    })
  }  

  return (
    <WithModal type={MODAL_TYPE} backdrop={true} onClick={handleClick} modalBoxSize="max-w-xl !overflow-auto">
      <form action=''>
        <h1 className='text-lg font-bold'>Konfirmasi</h1>
        {isLabel ? (
          <p>Apakah anda yakin ingin menandai {page.label} ini sebagai <div className={`capitalize badge badge-xs p-2 ${useStatus(`contact.${status}`)}`}>{useLang(`contact.${status}`)}</div>?</p>
        ) : null}

        <div className="">
          {!!data && !!content && typeof content === 'function' && content(data)}
        </div>
        <div className='modal-action'>
          <label ref={backButtonRef} onClick={handleClick} htmlFor={`modal_${MODAL_TYPE}`} className='btn btn-sm btn-neutral btn-outline'>
            Batal
          </label>
          <button onClick={handleSubmit} className={`btn btn-sm btn-success bg-green-600 text-white `} disabled={processing}>
            <span className={`${processing && 'loading'}`}></span>
            <span>Submit</span>
          </button>
        </div>
      </form>
    </WithModal>
  )
}

export default UpdateStatusModal
