import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { usePage } from "@inertiajs/react";

function Index(props) {
  return <DefaultCard />
}

const ReportCard = ({ children, label, icon }) => {
  return (
    <div className="border bg-blue-100 shadow-lg border-blue-200 bg-opacity-80 px-4 py-2 rounded-lg flex gap-2 w-full sm:w-max">
      <i className={`fas fa-3x opacity-80 ${icon}`}></i>
      <div className="">
        <p className="opacity-90">{label}</p>
        {children}
      </div>
    </div>
  )
}

const DefaultCard = () => {
  const { props } = usePage()

  return (
    <AuthenticatedLayout title={props.title}>
      <div className="flex flex-col items-center justify-center gap-4 pt-8">
        <p>
          Selamat Datang,{" "}
          <span className="font-semibold">
            {props.auth.user.name}
          </span>
        </p>
      </div>
    </AuthenticatedLayout>
  )
}

export default Index;
