import { Link, router, usePage } from "@inertiajs/react";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { useState } from "react";
import { ModalButton } from "@/Components/WithModal";
import Table from "@/Components/Table";
import DeleteModal from "@/Components/Modal/DeleteModal";
import { currency, useSearchParams } from "@/utlis/format";
import ApprovedModal from "@/Components/Modal/ApprovedModal";
import RejectedModal from "@/Components/Modal/RejectedModal";
import SubmitModal from "@/Components/Modal/SubmitModal";
import DetailModalItem from "@/Components/Default/DetailModalItem";
import DetailModal from "@/Components/Modal/DetailModal";
import YearFilter from "@/Components/YearFilter";
import useStatus, { useStatusLabel } from "@/utlis/useStatus";
import ApprovedEditModal from "./Modal/ApprovedEditModal";
import RejectedEditModal from "./Modal/RejectedEditModal";
import DetailEditModal from "./Modal/DetailEditModal";
import HistoryEditModal from "./Modal/HistoryEditModal";

function Index(props) {
  const tableHeader = useTableHeader();
  const filterOptions = useFilterOptions();

  const [show, setShow] = useState(null)
  const handleShow = (data) => {
    setShow(data)
  }

  return (
    <AuthenticatedLayout title={props?.title}>
      <Table search filter
        filterOptions={filterOptions}
        tableHeader={tableHeader}
        tableBody={props?.[props?.page?.name]?.data ?? []}
        tablePage={props?.[props?.page?.name]?.links}
        headerLeftButton={() => <YearFilter />}
        headerButton={() => (
          <>
            {props.isAdmin ? null : (
              <Link href={`${props?.page?.url}/create`} className="btn btn-primary w-max btn-sm text-white">
                Tambah {props?.page?.label}
              </Link>
            )}
          </>
        )}
        tableAction={(data) => {
          const { user } = props.auth

          let isDisabled = !props.isAdmin || !['review'].includes(data.status)
          if (['credit'].includes(data.type) && props.isAdmin && ['draft'].includes(data.status)) {
            isDisabled = false
          }

          let isCreditDisabled = !props.isAdmin || !['approved'].includes(data.status)
          if (['credit'].includes(data.type) && ['approved'].includes(data.status)) {
            isCreditDisabled = true
          }

          let isSubmitEditDisabled = !['approved'].includes(data.status) || data?.transactions_count > 0 || data.user_id != props?.auth?.user?.id
          if (!!data?.budget_edit && ['review'].includes(data?.budget_edit?.status) && !isSubmitEditDisabled) {
            isSubmitEditDisabled = true
          }

          return (
            <li>
              <ModalButton id={`detail_${data?.id}`} onClick={() => handleShow(data)}>
                <span>Lihat Detail</span>
              </ModalButton>
              {props.isAdmin ? (
                <>
                  <ModalButton disabled={isDisabled} id={`approved_${data?.id}`} onClick={() => handleShow(data)}>
                    <span className="text-green-700">Setujui {props?.page?.label}</span>
                  </ModalButton>
                  <ModalButton disabled={isDisabled} id={`rejected_${data?.id}`} onClick={() => handleShow(data)}>
                    <span className="text-red-700">Tolak {props?.page?.label}</span>
                  </ModalButton>
                  <button disabled={isCreditDisabled} className="disabled:opacity-50" onClick={() => router.get(`/admin/budget/create?type=credit&budget_id=${data?.id}&artist_id=${btoa(data?.artist_id)}`)}>
                    Kurangi Anggaran
                  </button>
                  <button disabled={!['draft'].includes(data.status)} className="disabled:opacity-50" onClick={() => router.get(`/admin/budget/${data?.id}/edit`)}>
                    Edit
                  </button>

                  <ModalButton disabled={!data?.budget_edit || !['review'].includes(data?.budget_edit?.status)} id={`approved_edit_${data?.id}`} onClick={() => handleShow(data)}>
                    <span className="text-green-700">Setujui Pengeditan {props?.page?.label}</span>
                  </ModalButton>
                  <ModalButton disabled={!data?.budget_edit || !['review'].includes(data?.budget_edit?.status)} id={`rejected_edit_${data?.id}`} onClick={() => handleShow(data)}>
                    <span className="text-red-700">Tolak Pengeditan {props?.page?.label}</span>
                  </ModalButton>
                </>
              ) : (
                <>
                  <ModalButton disabled={!['draft'].includes(data.status)} id={`submit_${data?.id}`} onClick={() => handleShow(data)}>
                    <span>Ajukan Persetujuan</span>
                  </ModalButton>
                  <button disabled={!['draft'].includes(data.status)} className="disabled:opacity-50" onClick={() => router.get(`/admin/budget/${data?.id}/edit`)}>
                    Edit
                  </button>
                  <button disabled={isSubmitEditDisabled} className="disabled:opacity-50" onClick={() => router.get(`/admin/budget/${data?.id}/edit-submit`)}>
                    Ajukan Pengeditan
                  </button>
                  <ModalButton disabled={!data?.budget_edit || !['review'].includes(data?.budget_edit?.status)} id={`detail_edit_${data?.id}`} onClick={() => handleShow(data)}>
                    <span>Detail Pengeditan</span>
                  </ModalButton>
                  {/* <ModalButton disabled={!props.isAdmin || !['draft'].includes(data.status)} id={`revision_${data?.id}`} onClick={() => handleShow(data)}>
                    <span>Ajukan Revisi</span>
                  </ModalButton>
                  <ModalButton disabled={!props.isAdmin || !['draft'].includes(data.status)} id={`deletion_${data?.id}`} onClick={() => handleShow(data)}>
                    <span>Ajukan Penghapusan</span>
                  </ModalButton> */}
                </>
              )}

              <ModalButton disabled={!data?.budget_edits || data?.budget_edits?.length == 0} id={`history_edit_${data?.id}`} onClick={() => handleShow(data)}>
                <span>Riwayat Pengajuan Edit</span>
              </ModalButton>

              <ModalButton disabled={!['draft'].includes(data?.status)} id={`delete_${data?.id}`} onClick={() => handleShow(data)}>
                <span className="text-red-700">Hapus Draft</span>
              </ModalButton>
            </li>
          )
        }}
        tableFooter={(tableProps) => {
          const { tableBody, tableHeader, defaultClassName: { tdBodyClassName, trBodyClassName } } = tableProps
          const dataSum = props?.[`${props?.page?.name}Sum`] ?? {}

          return (
            <tr className={`${trBodyClassName} bg-white w-full`}>
              <td colSpan={props.isAdmin ? 7 : 6} className={`${tdBodyClassName}`}>
                <div className="flex items-center justify-between w-full">
                  <span className="font-semibold">Total</span>
                </div>
              </td>
              <td>
                <span className="font-semibold">
                  {currency(dataSum?.debit_total ?? 0, "id-ID", dataSum?.category?.currency_code)}
                </span>
              </td>
              <td>
                <span className="font-semibold">
                  {currency(dataSum?.credit_total ?? 0, "id-ID", dataSum?.category?.currency_code)}
                </span>
              </td>
              <td>
                <span className="font-semibold">
                  {currency(dataSum?.remaining_total ?? 0, "id-ID", dataSum?.category?.currency_code)}
                </span>
              </td>
              <td colSpan={3}></td>
            </tr>
          )
        }}
      />

      {show ? (
        <>
          <DeleteModal id={show?.id} isForceDelete={show?.deleted_at != null} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} />
          <DetailModal id={show?.id} tableHeader={tableHeader} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} />
          <ApprovedModal id={show?.id} isLabel={true} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} />
          <RejectedModal id={show?.id} isLabel={true} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} />
          <SubmitModal id={show?.id} isLabel={true} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} />

          <HistoryEditModal id={show?.id} isLabel={true} data={show} handleClick={() => handleShow(null)} content={(data) => DetailHistoryBudgetEdit(data, tableHeader)} />
          <DetailEditModal id={show?.id} isLabel={true} data={show} handleClick={() => handleShow(null)} content={(data) => DetailBudgetEditContent(data, tableHeader)} />
          <ApprovedEditModal id={show?.id} isLabel={true} data={show} handleClick={() => handleShow(null)} content={(data) => DetailBudgetEditContent(data, tableHeader)} />
          <RejectedEditModal id={show?.id} isLabel={true} data={show} handleClick={() => handleShow(null)} content={(data) => DetailBudgetEditContent(data, tableHeader)} />
        </>
      ) : null}
    </AuthenticatedLayout>
  );
}

const DetailBudgetEditContent = (data, tableHeader) => {
  const hiddenFields = ["review_at", "user_review.name", "budget_edit.status"]
  tableHeader = tableHeader?.filter((header) => !hiddenFields.includes(header.value))

  return (
    <div className="">
      <div className="flex flex-col sm:flex-row gap-2 mt-2">
        <div className="flex-1">
          <p className="font-semibold">Data Sekarang</p>
          <div className="w-full border p-2">
            <DetailModalItem data={data} tableHeader={tableHeader} />
          </div>
        </div>
        <div className="flex-1">
          <p className="font-semibold">Data Baru</p>
          <div className="w-full border p-2">
            <DetailModalItem data={data?.budget_edit} tableHeader={tableHeader} />
          </div>
        </div>
      </div>
      <div className="w-full">
        <p className="font-semibold">Catatan Pengeditan</p>
        <div className="w-full border p-2">
          <p>{data?.budget_edit?.note ?? "-"}</p>
        </div>
      </div>
    </div>
  )
}

const DetailHistoryBudgetEdit = (data, tableHeader) => {
  const hiddenFields = ["review_at", "user_review.name", "budget_edit.status"]
  tableHeader = tableHeader?.filter((header) => !hiddenFields.includes(header.value))

  return (
    <div className="w-full flex flex-col gap-2">
      {data?.budget_edits?.map((budgetEdit) => {
        return (
          <div key={budgetEdit?.id} className="w-full border p-2">
            <DetailModalItem data={budgetEdit} tableHeader={tableHeader} />
            <div className="w-full">
              <p className="font-semibold">Catatan Pengeditan</p>
              <div className="w-full border p-2">
                <p>{budgetEdit?.note ?? "-"}</p>
              </div>
            </div>
          </div>
        )
      })}
    </div>
  )
}

const DetailModalContent = (data, tableHeader) => {
  return (
    <div className="w-full border p-2">
      <DetailModalItem data={data} tableHeader={tableHeader} />
    </div>
  )
}

const useTableHeader = () => {
  const { page, isAdmin, location } = usePage().props
  const { params } = useSearchParams(location)
  const header = [
    {
      label: "#",
      value: "id",
      type: "numbering",
    },
    {
      label: `Kode ${page?.label}`,
      value: "code",
      className: 'text-[13px] w-[10%] md:w-[100px]',
      isSearchable: true,
    },
    {
      label: `Jenis Anggaran`,
      value: "type",
      className: 'text-[13px] w-[10%] md:w-[100px]',
      isDetail: true,
      prefix: `budget.type.`,
    },
    {
      label: "Tanggal",
      value: "date",
      type: "date",
      isSearchable: true,
      className: 'text-[13px] w-[10%] md:w-[100px] !whitespace-pre',
      dateFormat: 'DD MMM YYYY'
    },
    {
      label: `Disubmit`,
      value: "user.name",
      className: 'text-[13px] w-[10%] md:w-[100px]',
      isSearchable: true,
      isDetail: false,
      isHidden: !isAdmin,
    },
    {
      label: `Artis`,
      value: "artist.NAMA",
      code: "artist.KODE",
      className: 'text-[13px] w-[10%] md:w-[150px]',
      isSearchable: true,
    },
    {
      label: `Kategori`,
      value: "category.name",
      // code: "category.code",
      className: 'text-[13px] w-[10%] md:w-[150px]',
      isSearchable: true,
    },
    {
      label: `Keterangan`,
      value: "description",
      className: 'text-[13px] w-[10%] md:w-[500px]',
      isSearchable: true,
    },
    {
      label: "Debit",
      value: "debit_amount",
      className: 'text-[13px] w-[10%] md:w-[120px]',
      type: 'currency',
      currency_code: 'category.currency_code'
    },
    {
      label: "Kredit",
      value: "credit_amount",
      className: 'text-[13px] w-[10%] md:w-[120px]',
      type: 'currency',
      currency_code: 'category.currency_code'
    },
    {
      label: "Anggaran Tersedia",
      value: "remaining_amount",
      className: 'text-[13px] w-[10%] md:w-[120px]',
      type: 'currency',
      currency_code: 'category.currency_code'
    },
    {
      label: "Tahun",
      value: "year",
      className: 'text-[13px] w-[10%] md:w-[80px]',
      isSearchable: true,
    },
    {
      label: "Status",
      value: "status",
      type: "status",
      className: '[&_div]:text-[13px] w-[10%]',
      prefix: `${page?.name}.`,
      isDetail: false,
      custom: ({ data, key, header, defaultClassName }) => {
        return (
          <td key={key} className={`${defaultClassName?.tdBodyClassName} ${header?.className ?? ''}`}>
            <div className={`capitalize badge badge-xs py-2 ${useStatus(`${header?.prefix ?? ''}${data?.status}`)}`}>{useStatusLabel(`${header?.prefix ?? ''}${data?.status}`)}</div>
            {data?.budget_edit?.status && data?.budget_edit.status == 'review' ? (
              <div className={`capitalize badge badge-xs py-2 ${useStatus(`budget_edit.${data?.budget_edit?.status}`)}`}>{useStatusLabel(`budget_edit.${data?.budget_edit?.status}`)}</div>
            ) : null}
          </td>
        )
      }
    },
    {
      label: "Status",
      value: "status",
      type: "status",
      className: '[&_div]:text-[13px] w-[10%]',
      prefix: `${page?.name}.`,
      isDetail: true,
    },
    {
      label: "Status Pengeditan",
      value: "budget_edit.status",
      type: "status",
      className: '[&_div]:text-[13px] w-[10%]',
      prefix: `budget_edit.`,
      isDetail: true,
      isHidden: 'not null',
    },
    {
      label: "Terakhir Diedit",
      value: "budget_edit.review_at",
      type: "date",
      isHidden: 'not null',
      isDetail: true,
      className: 'text-[13px] w-[10%] md:w-[100px]',
      dateFormat: 'DD MMM YYYY hh:mm'
    },
    {
      label: "Alasan [label]",
      value: "status_message",
      type: "status_message",
      className: '[&_div]:text-[13px] w-[10%]',
      prefix: `${page?.name}.`,
      isDetail: true,
    },
    {
      label: "Aksi",
      value: "id",
      type: "action",
      className: 'w-[10%]',
    },
    {
      label: `Di Submit Oleh`,
      value: "user.name",
      className: 'text-[13px] w-[10%] md:w-[100px]',
      isDetail: true,
      isHidden: !isAdmin,
    },
    {
      label: `Di Review Oleh`,
      value: "user_review.name",
      className: 'text-[13px] w-[10%] md:w-[100px]',
      isDetail: true,
      isHidden: 'not null',
    },
    {
      label: "Tanggal Review",
      value: "review_at",
      type: "date",
      isHidden: 'not null',
      isDetail: true,
      className: 'text-[13px] w-[10%] md:w-[100px]',
      dateFormat: 'DD MMM YYYY hh:mm'
    },
  ];

  return header;
};

const useFilterOptions = () => {
  const { props } = usePage()
  const filterOptions = [
    {
      name: 'Jenis Anggaran',
      data: props?.type,
      label: 'Filter Jenis Anggaran',
      prefix: 'budget.type',
    },
    {
      name: 'status',
      data: props?.status,
      label: 'Filter Status',
      prefix: 'budget',
    },
    {
      name: 'category_id',
      data: props?.category_id,
      label: 'Filter Kategori',
      isReactSelect: true,
    },
    {
      name: 'artist_id',
      data: props?.artist_id,
      label: 'Filter Artis',
      isReactSelect: true,
    },
  ]

  return filterOptions
};

export default Index;
