import WithModal from '@/Components/WithModal'
import { useForm, usePage } from '@inertiajs/react'
import { useRef } from 'react'

const ApprovedEditModal = (state) => {
  const { id, data = null, isLabel = true, content = null, handleClick } = state
  const MODAL_TYPE = `approved_edit_${id}`
  const { page } = usePage().props

  const backButtonRef = useRef()
  const { put, processing } = useForm({
    approvedEdit: '1',
    budget_edit_id: data?.budget_edit?.id
  })

  const handleSubmit = (e) => {
    e.preventDefault()
    put(`${page.url}/${id}`, {
      onSuccess: () => {
        backButtonRef.current?.click()
      }
    })
  }

  return (
    <WithModal type={MODAL_TYPE} backdrop={true} onClick={handleClick} modalBoxSize="max-w-4xl !overflow-auto">
      <form action=''>
        <h1 className='text-lg font-bold'>Konfirmasi</h1>
        {isLabel ? (
          <p>Apakah anda yakin ingin setujui pengeditan {page.label} ini?</p>
        ) : null}

        <div className='mb-3 p-2 bg-orange-200 rounded-md flex'>
          <i className='fas fa-circle-exclamation mr-2 mt-1' />
          Jika disetujui, anggaran akan menggunakan data baru
        </div>
        <div className="">
          {!!data && !!content && typeof content === 'function' && content(data)}
        </div>
        <div className='modal-action'>
          <label ref={backButtonRef} htmlFor={`modal_${MODAL_TYPE}`} className='btn btn-sm btn-neutral btn-outline'>
            Batal
          </label>
          <button onClick={handleSubmit} className={`btn btn-sm btn-success bg-green-600 text-white `} disabled={processing}>
            <span className={`${processing && 'loading'}`}></span>
            <span>Setujui Pengeditan {page.label}</span>
          </button>
        </div>
      </form>
    </WithModal>
  )
}

export default ApprovedEditModal
