import WithModal from '@/Components/WithModal'
import { useRef } from 'react'

const DetailEditModal = (state) => {
  const { id, data = null, isLabel = true, content = null, handleClick } = state
  const MODAL_TYPE = `detail_edit_${id}`
  const backButtonRef = useRef()

  return (
    <WithModal type={MODAL_TYPE} backdrop={true} onClick={handleClick} modalBoxSize="max-w-4xl !overflow-auto">
      <form action=''>
        <h1 className='text-lg font-bold'>Detail Pengeditan Anggaran</h1>
        <div className='mb-3 p-2 bg-orange-200 rounded-md flex'>
          <i className='fas fa-circle-exclamation mr-2 mt-1' />
          Jika disetujui, anggaran akan menggunakan data baru
        </div>
        
        <div className="">
          {!!data && !!content && typeof content === 'function' && content(data)}
        </div>
        <div className='modal-action'>
          <label ref={backButtonRef} htmlFor={`modal_${MODAL_TYPE}`} className='btn btn-sm btn-neutral btn-outline'>
            Kembali
          </label>
        </div>
      </form>
    </WithModal>
  )
}

export default DetailEditModal
