import WithModal from '@/Components/WithModal'
import { useRef } from 'react'

const HistoryEditModal = (state) => {
  const { id, data = null, isLabel = true, content = null, handleClick } = state
  const MODAL_TYPE = `history_edit_${id}`
  const backButtonRef = useRef()

  return (
    <WithModal type={MODAL_TYPE} backdrop={true} onClick={handleClick} modalBoxSize="max-w-4xl !overflow-auto !scrollbar-thin">
      <form action=''>
        <h1 className='text-lg font-bold'>Riwayat Pengajuan Edit Anggaran</h1>        
        <div className="">
          {!!data && !!content && typeof content === 'function' && content(data)}
        </div>
        <div className='modal-action'>
          <label ref={backButtonRef} htmlFor={`modal_${MODAL_TYPE}`} className='btn btn-sm btn-neutral btn-outline'>
            Kembali
          </label>
        </div>
      </form>
    </WithModal>
  )
}

export default HistoryEditModal
