import FormBuilder from '@/Components/FormBuilder';
import { mimeType, useSearchParams } from '@/utlis/format';
import useFormBuilder from '@/utlis/useFormBuilder';
import useLang from '@/utlis/useLang';

function MainForm({ isEdit = false }) {
  const formConfig = { isEdit, getProperties }
  const builderProps = useFormBuilder(formConfig)

  return (
    <FormBuilder {...builderProps} />
  )
}

const getProperties = (state) => {
  const { setData, props, data } = state
  const { params } = useSearchParams(props.location)

  const properties = [
    [
      {
        form: 'textarea',
        props: {
          name: 'description_id',
          label: 'Deskripsi',
          setData: setData,
          alt: useLang('lang.id', state.props)
        }
      },
      {
        form: 'textarea',
        props: {
          name: 'description_en',
          label: 'Deskripsi',
          setData: setData,
          alt: useLang('lang.en', state.props)
        }
      },
    ],
    [
      {
        form: 'input',
        imagePreview: true,
        isSidePreview: false,
        previewLabel: 'Preview:',
        previewClassName: "w-[160px] h-[160px] object-cover border rounded-md",
        props: {
          name: 'image',
          label: 'Gambar',
          type: 'file',
          accept: mimeType('image'),
        },
      },
      {
        form: 'select',
        props: {
          name: 'status',
          label: 'Status',
          options: props.status,
          defaultValue: data.status,
        }
      },
    ]
  ]

  return properties
}
export default MainForm
