import SEOQuality from '@/Components/Default/SEOQuality';
import FormBuilder from '@/Components/FormBuilder';
import { slugify, useSearchParams } from '@/utlis/format';
import useFormBuilder from '@/utlis/useFormBuilder';
import useLang from '@/utlis/useLang';
import { usePage } from '@inertiajs/react';
import { useEffect } from 'react';

function MainForm({ isEdit = false }) {
  const { page } = usePage().props

  const onSubmit = (e, form) => {
    const { post, data } = form

    if (page?.data) {
      data._method = 'put'
      let id = page?.data?.id
      if (!id && page?.data?.id_id) {
        id = page?.data?.id_id
      }
      if (!id && page?.data?.id_en) {
        id = page?.data?.id_en
      }
      return post(`${page?.url}/${id}`);
    }
    return post(`${page?.url}`);
  };

  const formConfig = { isEdit, getProperties, onSubmit }

  const builderProps = useFormBuilder(formConfig)

  const { data, setData } = builderProps.form

  useEffect(() => {
    let filteredSlug = ''
    if (data.name_id && !isEdit) {
      const slug = slugify(data.name_id)
      filteredSlug = `${slug}`
    }

    if (!isEdit) {
      setData('slug_id', filteredSlug)
    }

  }, [data.name_id])

  useEffect(() => {
    let filteredSlug = ''
    if (data.name_en && !isEdit) {
      const slug = slugify(data.name_en)
      filteredSlug = `${slug}`
    }

    if (!isEdit) {
      setData('slug_en', filteredSlug)
    }
  }, [data.name_en])

  useEffect(() => {
    const desc = data?.seo_description_id

    if (desc && desc.length > 160) {
      const truncated = desc.substring(0, 160)
      if (desc !== truncated) {
        setData('seo_description_id', truncated)
      }
    }
  }, [data?.seo_description_id])

  useEffect(() => {
    const desc = data?.seo_description_en

    if (desc && desc.length > 160) {
      const truncated = desc.substring(0, 160)
      if (desc !== truncated) {
        setData('seo_description_en', truncated)
      }
    }
  }, [data?.seo_description_en])

  return (
    <FormBuilder {...builderProps} />
  )
}

const getProperties = (state) => {
  const { setData, props, data, errors } = state
  const { params } = useSearchParams(props.location)

  const properties = [
    [
      {
        form: 'select',
        props: {
          isReactSelect: true,
          isCreateAble: true,
          name: 'brand_id',
          label: 'Merek',
          options: props.brands,
          handleChange: (e) => setData('brand_id', !!e?.__isNew__ ? e : e?.value),
        }
      }
    ],
    [
      {
        form: 'select',
        props: {
          isReactSelect: true,
          isVirtualized: true,
          name: 'category_id_id',
          label: 'Kategori',
          options: props.categories.id,
          handleChange: (e) => setData('category_id_id', e?.value),
          alt: useLang('lang.id', state.props),
        }
      },
      {
        form: 'select',
        props: {
          isReactSelect: true,
          isVirtualized: true,
          name: 'category_id_en',
          label: 'Kategori',
          options: props.categories.en,
          handleChange: (e) => setData('category_id_en', e?.value),
          alt: useLang('lang.en', state.props),
        }
      },
    ],
    [
      {
        form: 'input',
        props: {
          name: 'name_id',
          label: `Nama ${props.page?.label}`,
          type: 'text',
          alt: useLang('lang.id', state.props)
        }
      },
      {
        form: 'input',
        props: {
          name: 'name_en',
          label: `Nama ${props.page?.label}`,
          type: 'text',
          alt: useLang('lang.en', state.props)
        }
      },
    ],
    [
      {
        form: 'input',
        props: {
          name: 'slug_id',
          label: 'Slug',
          type: 'text',
          alt: useLang('lang.id', state.props)
        }
      },
      {
        form: 'input',
        props: {
          name: 'slug_en',
          label: 'Slug',
          type: 'text',
          alt: useLang('lang.en', state.props)
        }
      },
    ],
    [
      {
        form: 'textarea',
        props: {
          isTextEditor: true,
          name: 'description_id',
          label: 'Deskripsi',
          setData: setData,
          alt: useLang('lang.id', state.props)
        }
      },
      {
        form: 'textarea',
        props: {
          isTextEditor: true,
          name: 'description_en',
          label: 'Deskripsi',
          setData: setData,
          alt: useLang('lang.en', state.props)
        }
      },
    ],
    [
      {
        form: 'textarea',
        props: {
          name: 'seo_description_id',
          label: 'SEO Deskripsi',
          setData: setData,
          alt: useLang('lang.id', state.props),
          bottomLabel: 'Maksimal 160 Karakter'
        }
      },
      {
        form: 'textarea',
        props: {
          name: 'seo_description_en',
          label: 'SEO Deskripsi',
          setData: setData,
          alt: useLang('lang.en', state.props),
          bottomLabel: 'Maksimal 160 Karakter'
        }
      },
    ],
    [
      {
        form: 'textarea',
        props: {
          name: 'seo_keyword_id',
          label: 'SEO Keyword',
          setData: setData,
          alt: useLang('lang.id', state.props),
          placeHolder: 'tips dan trik, panduan',
          bottomLabel: 'Pisahkan dengan koma'
        },
        infoCard: (property, inputProps) => <SEOQuality property={property} inputProps={inputProps} lang='id' />
      },
      {
        form: 'textarea',
        props: {
          name: 'seo_keyword_en',
          label: 'SEO Keyword',
          setData: setData,
          alt: useLang('lang.en', state.props),
          placeHolder: 'tips and tricks, guide',
          bottomLabel: 'Pisahkan dengan koma'
        },
        infoCard: (property, inputProps) => <SEOQuality property={property} inputProps={inputProps} lang='en' />
      },
    ],
    [
      {
        form: 'FileUploader',
        props: {
          name: 'images',
          label: 'Upload Gambar',
          accept: 'image',
          setData: setData
        }
      },
      {
        form: 'select',
        props: {
          name: 'status',
          label: 'Status',
          options: props.status,
          defaultValue: data.status,
        }
      },
    ]
  ]

  return properties
}
export default MainForm
