import FormBuilder from '@/Components/FormBuilder';
import { useSearchParams } from '@/utlis/format';
import useFormBuilder from '@/utlis/useFormBuilder';
import useFormChange from '@/utlis/useFormChange';
import useLang from '@/utlis/useLang';
import { useState } from 'react';

function MainForm({ isEdit = false }) {
  const formConfig = { isEdit, getProperties }
  const builderProps = useFormBuilder(formConfig)

  return (
    <FormBuilder {...builderProps} />
  )
}

const getProperties = (state) => {
  const { setData, props, data, isEdit } = state
  const { params } = useSearchParams(props.location)


  const handleSelectedForm = (value, isSetState = false) => {
    let selected = props.formTypes[value]
    if (!selected) return

    selected = selected.split(':')

    let data = {}
    if (selected?.[0]) {
      data['selectedForm'] = selected?.[0]?.toLowerCase()

      if (isSetState) {
        setSelectedForm(selected?.[0]?.toLowerCase())
      }
    }
    if (selected?.length > 1 && selected?.[1]) {
      data['selectedFormType'] = selected?.[1]?.toLowerCase()

      if (isSetState) {
        setSelectedFormType(selected?.[1]?.toLowerCase())
      }
    }

    return data
  }

  const selected = handleSelectedForm(data?.type)
  const [selectedForm, setSelectedForm] = useState(selected?.selectedForm)
  const [selectedFormType, setSelectedFormType] = useState(selected?.selectedFormType)
  const labelTypes = ['marketSegmentList']

  const handleChangeType = (e, name) => {
    let newState = {}
    newState[name] = e?.value ?? ''

    if (!newState[name]) {
      newState[name] = e ?? ''
    }
    setData((state) => ({ ...state, ...newState }))

    if (name != 'type') return
    handleSelectedForm(newState[name], true)
  }

  const typeOptions = props.types.map((data) => {
    return {
      label: useLang(`profile.${data}`, props),
      value: data,
    }
  })  

  const properties = [
    [
      {
        form: 'select',
        props: {
          isDisabled: !!isEdit && !props?.createableForm?.includes(data.type),
          isReactSelect: true,
          name: 'type',
          label: `Jenis ${props.page?.label}`,
          options: typeOptions,
          handleChange: (e) => handleChangeType(e, 'type'),
        }
      },
    ],
    [
      {
        form: 'input',
        isHidden: !labelTypes.includes(data.type),
        props: {
          name: 'label_id',
          label: 'Label',
          type: 'text',
          alt: useLang('lang.id', state.props)
        }
      },
      {
        form: 'input',
        isHidden: !labelTypes.includes(data.type),
        props: {
          name: 'label_en',
          label: 'Label',
          type: 'text',
          alt: useLang('lang.en', state.props)
        }
      },
    ],
    [
      {
        form: selectedForm,
        props: {
          isTextEditor: ['texteditor'].includes(selectedFormType),
          name: 'content_id',
          label: 'Konten',
          type: selectedFormType,
          setData: setData,
          alt: useLang('lang.id', state.props)
        }
      },
      {
        form: selectedForm,
        props: {
          isTextEditor: ['texteditor'].includes(selectedFormType),
          name: 'content_en',
          label: 'Konten',
          type: selectedFormType,
          setData: setData,
          alt: useLang('lang.en', state.props)
        }
      },
    ],
    [
      {
        form: 'select',
        props: {
          isDisabled: !props?.createableForm?.includes(data.type),
          name: 'status',
          label: 'Status',
          options: props.status,
          defaultValue: data.status,
        }
      },
    ]
  ]

  return properties
}
export default MainForm
