import { Link, usePage } from "@inertiajs/react";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { useState } from "react";
import { ModalButton } from "@/Components/WithModal";
import Table from "@/Components/Table";
import DeleteModal from "@/Components/Modal/DeleteModal";
import { useSearchParams } from "@/utlis/format";
import LangFilter from "@/Components/LangFilter";
import DetailModal from "@/Components/Modal/DetailModal";
import DetailModalContent from "@/Components/Default/DetailModalContent";

function Index(props) {
  const tableHeader = useTableHeader();
  const filterOptions = useFilterOptions();

  const [show, setShow] = useState(null)
  const handleShow = (data) => {
    setShow(data)
  }

  return (
    <AuthenticatedLayout title={props?.title}>
      <Table search filter
        filterOptions={filterOptions}
        tableHeader={tableHeader}
        headerLeftButton={() => <LangFilter />}
        tableBody={props?.[props?.page?.name]?.data ?? []}
        tablePage={props?.[props?.page?.name]?.links}
        headerButton={() => (
          <>
            <Link href={`${props?.page?.url}/create`} className="btn btn-primary w-max btn-sm text-white">
              Tambah {props?.page?.label}
            </Link>
          </>
        )}
        tableAction={(data) => (
          <>
            <li>
              <ModalButton id={`detail_${data?.id}`} onClick={() => handleShow(data)}>
                <span>Lihat Detail</span>
              </ModalButton>
            </li>
            <li>
              <Link href={`${props?.page?.url}/${data.id}/edit`} className=''>
                Edit
              </Link>
            </li>
            <li>
              <ModalButton disabled={!props?.createableForm?.includes(data?.type)} id={`modal_delete_${data?.id}`} onClick={() => handleShow(data)}>
                Hapus
              </ModalButton>
            </li>
          </>
        )}
      />

      {show ? (
        <>
          <DeleteModal id={show?.id} label={show.name} isForceDelete={show.deleted_at != null} handleClick={() => handleShow(null)} />
          <DetailModal id={show?.id} tableHeader={tableHeader} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} size='max-w-5xl' />
        </>
      ) : null}
    </AuthenticatedLayout>
  );
}

const useTableHeader = () => {
  const { page, isAdmin, location, imageTypes} = usePage().props
  const { params } = useSearchParams(location)

  const header = [
    {
      label: "#",
      value: "id",
      type: "numbering",
    },
    {
      label: `Bahasa`,
      value: "lang",
      className: 'w-[50px]',
      prefix: 'lang.'
    },
    {
      label: `Jenis`,
      value: "type",
      className: 'w-[200px]',
      isSearchable: true,
      prefix: 'profile.'
    },
    {
      label: `Konten`,
      value: "content",
      className: 'w-[500px]',
      isSearchable: true,
      isDetail: false,
      custom: ({ data, key, header, defaultClassName }) => {
        return (
          <td key={key} className={`${defaultClassName?.tdBodyClassName} ${header?.className ?? ''} overflow-hidden whitespace-pre max-w-[500px]`}>
            {data?.label ? <p className="font-semibold">{data?.label}</p> : null}
            {imageTypes?.includes(data.type) ? (
              <img src={data?.content} className="w-[200px] h-[200px] object-cover rounded-md" />
            ) : (
              <div className="text-editor-content" dangerouslySetInnerHTML={{ __html: data?.content }}></div>
            )}
          </td>
        )
      }
    },
    {
      label: "Status",
      value: "status",
      type: "status",
      className: 'w-[10%]',
    },
    {
      label: "Dibuat",
      value: "created_at",
      type: "date",
      isSearchable: true,
      className: 'w-[10%]',
    },
    {
      label: "Diperbarui",
      value: "updated_at",
      type: "date",
      isSearchable: true,
      className: 'w-[10%]',
    },
    {
      label: "Aksi",
      value: "id",
      type: "action",
      className: 'w-[10%]',
    },
    {
      isDetail: true,
      label: "label",
      value: "label",
      wrapperClassName: "flex flex-col",
      defaultValue: '-'
    },
    {
      isDetail: true,
      label: "Konten",
      value: "content",
      wrapperClassName: "flex flex-col max-w-[85vw] overflow-auto",
      type: "html",
      defaultValue: '-'
    },
  ];

  return header;
};

const useFilterOptions = () => {
  const { props } = usePage()
  const filterOptions = [
    {
      name: 'status',
      data: props?.status,
      label: 'Filter Status',
    },
    {
      name: 'type',
      data: props?.types,
      label: 'Filter Jenis',
      prefix: 'profile'
    },
  ]

  return filterOptions
};

export default Index;
