import SEOQuality from '@/Components/Default/SEOQuality';
import FormBuilder from '@/Components/FormBuilder';
import { useSearchParams } from '@/utlis/format';
import useFormBuilder from '@/utlis/useFormBuilder';
import useLang from '@/utlis/useLang';
import { useEffect } from 'react';

function MainForm({ isEdit = false }) {
  const formConfig = { isEdit, getProperties }
  const builderProps = useFormBuilder(formConfig)

  const { data, setData } = builderProps.form
  useEffect(() => {
    const desc = data?.seo_description_id

    if (desc && desc.length > 160) {
      const truncated = desc.substring(0, 160)
      if (desc !== truncated) {
        setData('seo_description_id', truncated)
      }
    }
  }, [data?.seo_description_id])

  useEffect(() => {
    const desc = data?.seo_description_en

    if (desc && desc.length > 160) {
      const truncated = desc.substring(0, 160)
      if (desc !== truncated) {
        setData('seo_description_en', truncated)
      }
    }
  }, [data?.seo_description_en])

  return (
    <FormBuilder {...builderProps} />
  )
}

const getProperties = (state) => {
  const { setData, props, data, errors } = state
  const { params } = useSearchParams(props.location)

  const handleChangeType = (e, name) => {
    let newState = {}
    newState[name] = e?.value ?? ''

    if (!newState[name]) {
      newState[name] = e ?? ''
    }
    setData((state) => ({ ...state, ...newState }))
  }

  const typeOptions = props.types.map((data) => {
    return {
      label: useLang(`seo.${data}`, props),
      value: data,
    }
  })

  const properties = [
    // [
    //   {
    //     form: 'select',
    //     props: {
    //       isReactSelect: true,
    //       name: 'type',
    //       label: `Halaman`,
    //       options: typeOptions,
    //       handleChange: (e) => handleChangeType(e, 'type'),
    //     }
    //   },
    // ],
    [
      {
        form: 'input',
        props: {
          name: 'title_id',
          label: `Title`,
          type: 'text',
          alt: useLang('lang.id', state.props)
        }
      },
      {
        form: 'input',
        props: {
          name: 'title_en',
          label: `Title`,
          type: 'text',
          alt: useLang('lang.en', state.props)
        }
      },
    ],
    [
      {
        form: 'textarea',
        props: {
          name: 'seo_description_id',
          label: 'SEO Deskripsi',
          setData: setData,
          alt: useLang('lang.id', state.props),
          bottomLabel: 'Maksimal 160 Karakter'
        }
      },
      {
        form: 'textarea',
        props: {
          name: 'seo_description_en',
          label: 'SEO Deskripsi',
          setData: setData,
          alt: useLang('lang.en', state.props),
          bottomLabel: 'Maksimal 160 Karakter'
        }
      },
    ],
    [
      {
        form: 'textarea',
        props: {
          name: 'seo_keyword_id',
          label: 'SEO Keyword',
          setData: setData,
          alt: useLang('lang.id', state.props),
          placeHolder: 'tips dan trik, panduan',
          bottomLabel: 'Pisahkan dengan koma'
        },
        infoCard: (property, inputProps) => <SEOQuality property={property} inputProps={inputProps} lang='id' />
      },
      {
        form: 'textarea',
        props: {
          name: 'seo_keyword_en',
          label: 'SEO Keyword',
          setData: setData,
          alt: useLang('lang.en', state.props),
          placeHolder: 'tips and tricks, guide',
          bottomLabel: 'Pisahkan dengan koma'
        },
        infoCard: (property, inputProps) => <SEOQuality property={property} inputProps={inputProps} lang='en' />
      },
    ],
  ]

  return properties
}
export default MainForm
