import { Link, usePage } from "@inertiajs/react";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { useState } from "react";
import { ModalButton } from "@/Components/WithModal";
import Table from "@/Components/Table";
import DeleteModal from "@/Components/Modal/DeleteModal";
import { useSearchParams } from "@/utlis/format";
import LangFilter from "@/Components/LangFilter";
import DetailModal from "@/Components/Modal/DetailModal";
import DetailModalContent from "@/Components/Default/DetailModalContent";

function Index(props) {
  const tableHeader = useTableHeader();
  const filterOptions = useFilterOptions();

  const [show, setShow] = useState(null)
  const handleShow = (data) => {
    setShow(data)
  }

  return (
    <AuthenticatedLayout title={props?.title}>
      <Table search filter
        filterOptions={filterOptions}
        tableHeader={tableHeader}
        headerLeftButton={() => <LangFilter />}
        tableBody={props?.[props?.page?.name]?.data ?? []}
        tablePage={props?.[props?.page?.name]?.links}
        tableAction={(data) => (
          <>
            <li>
              <ModalButton id={`detail_${data?.id}`} onClick={() => handleShow(data)}>
                <span>Lihat Detail</span>
              </ModalButton>
            </li>
            <li>
              <Link href={`${props?.page?.url}/${data.id}/edit`} className=''>
                Edit
              </Link>
            </li>
          </>
        )}
      />

      {show ? (
        <>
          <DeleteModal id={show?.id} label={show.name} isForceDelete={show.deleted_at != null} handleClick={() => handleShow(null)} />
          <DetailModal id={show?.id} tableHeader={tableHeader} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} size='max-w-5xl' />
        </>
      ) : null}
    </AuthenticatedLayout>
  );
}

const useTableHeader = () => {
  const { page, isAdmin, location } = usePage().props
  const { params } = useSearchParams(location)

  const header = [
    {
      label: "#",
      value: "id",
      type: "numbering",
    },
    {
      label: `Bahasa`,
      value: "lang",
      className: 'w-[50px]',
      prefix: 'lang.'
    },
    {
      label: `Halaman`,
      value: "type",
      className: 'w-[200px]',
      isSearchable: true,
      prefix: 'seo.'
    },
    {
      label: `Title`,
      value: "title",
      className: 'w-[200px]',
      isSearchable: true,
    },
    {
      label: `Description`,
      value: "seo_description",
      className: 'w-[500px]',
      isSearchable: true,
    },
    {
      label: `Keyword`,
      value: "seo_keyword",
      className: 'w-[500px]',
      isSearchable: true,
    },
    // {
    //   label: "Status",
    //   value: "status",
    //   type: "status",
    //   className: 'w-[10%]',
    // },
    {
      label: "Dibuat",
      value: "created_at",
      type: "date",
      isSearchable: true,
      className: 'w-[10%]',
    },
    {
      label: "Diperbarui",
      value: "updated_at",
      type: "date",
      isSearchable: true,
      className: 'w-[10%]',
    },
    {
      label: "Aksi",
      value: "id",
      type: "action",
      className: 'w-[10%]',
    }
  ];

  return header;
};

const useFilterOptions = () => {
  const { props } = usePage()
  const filterOptions = [
    // {
    //   name: 'status',
    //   data: props?.status,
    //   label: 'Filter Status',
    // },
    {
      name: 'type',
      data: props?.types,
      label: 'Filter Halaman',
      prefix: 'seo'
    },
  ]

  return filterOptions
};

export default Index;
