import FormBuilder from '@/Components/FormBuilder';
import { useSearchParams } from '@/utlis/format';
import useFormBuilder from '@/utlis/useFormBuilder';
import useLang from '@/utlis/useLang';

function MainForm({ isEdit = false }) {
  const formConfig = { isEdit, getProperties }
  const builderProps = useFormBuilder(formConfig)

  return (
    <FormBuilder {...builderProps} />
  )
}

const getProperties = (state) => {
  const { setData, props, data, errors } = state
  const { params } = useSearchParams(props.location)

  const properties = [
    [
      {
        form: 'input',
        props: {
          name: 'name',
          label: `Nama Pelanggan`,
          type: 'text',
        }
      },
    ],
    [
      {
        form: 'textarea',
        props: {
          name: 'message_id',
          label: 'Pesan',
          setData: setData,
          alt: useLang('lang.id', state.props)
        }
      },
      {
        form: 'textarea',
        props: {
          name: 'message_en',
          label: 'Pesan',
          setData: setData,
          alt: useLang('lang.en', state.props)
        }
      },
    ],
    [
      {
        form: 'select',
        props: {
          name: 'status',
          label: 'Status',
          options: props.status,
          defaultValue: data.status,
        }
      },
    ]
  ]

  return properties
}
export default MainForm
