import { Link, router, useForm, usePage } from '@inertiajs/react'

import AuthenticatedLayout from '@/Layouts/AuthenticatedLayout'
import Input from '@/Components/Form/Input'
import useLang from '@/utlis/useLang'
import { jsonParse } from '@/utlis/format';

function Index(props) {
  const { langs, types, translations } = props
  const location = new URL(props.location)
  const params = new URLSearchParams(location.search)

  return (
    <AuthenticatedLayout title={props.title} auth={props.auth}>
      <div className="flex flex-col sm:flex-row flex-wrap gap-4 m-2">
        {translations.map((translation, index) => (
          <div key={index} className='flex-1'>
            <TranslationContent translation={translation} />
          </div>
        ))}
      </div>
    </AuthenticatedLayout>
  )
}

const TranslationContent = (props) => {
  let contents = jsonParse(props?.translation?.content)
  const defaultLang = 'id'
  const { lang } = props.translation

  let jsonContent = {}
  const allTranslations = import.meta.glob('@/locales/**/*.json', { eager: true })
  let matchPath = Object.keys(allTranslations).find(path => path.includes(`/${lang}/`))
  
  if (!matchPath) {
    matchPath = Object.keys(allTranslations).find(path => path.includes(`/${defaultLang}/`))
  }

  if (matchPath) {
    jsonContent = allTranslations[matchPath].default
  }

  contents = {...jsonContent, ...contents}
  if (!contents) {
    return <p>Tidak dapat memuat data terjemahan</p>
  }

  
  const { data, setData, } = useForm(contents)
  contents = Object.entries(contents)
  
  contents = contents.map((content) => {
    let data = {
      label: content[0],
      value: content[1],
    }
    return data
  })

  const groupeds = []

  for (const item of contents) {
    const parts = item.label.split('.')
    if (parts.length >= 2) {
      const section = parts[0]
      const group = parts[1]
      const tag = parts[2]

      let sectionObj = groupeds.find(s => s.section === section)
      if (!sectionObj) {
        sectionObj = { section, groups: [] }
        groupeds.push(sectionObj)
      }

      let groupObj = sectionObj.groups.find(g => g.group === group)
      if (!groupObj) {
        groupObj = { group, items: [] }
        sectionObj.groups.push(groupObj)
      }      

      item['tag'] = tag
      groupObj.items.push(item)
    }
  }

  const { data: translation, setData: setTranslation, post, errors, processing } = useForm({
    id: props.translation?.id ?? '',
    lang: props.translation?.lang ?? '',
    content: props.translation?.content ?? '',
  })

  function handleChange(e) {
    const { name, value } = e.target

    setData((state) => ({
      ...state,
      [name]: value
    }))
  }

  const handleSubmit = (e) => {
    e.preventDefault()
    translation._method = 'put'
    translation.content = JSON.stringify(data)
    
    post(`/admin/translation/${translation?.id || 'store'}`, {
      onSuccess: () => router.reload({ only: ['translations'], async: false })
    })
  }
  const handleCopy = () => {
    const filteredData = JSON.stringify(data).replaceAll('","', '",\n"').replace('{', '{\n').replace('}', '\n}')
    navigator.clipboard.writeText(filteredData);
    alert('Terjemahan telah disalin')
  };

  return (
    <div className="flex flex-col gap-4 p-4 border rounded-lg shadow">
      <div className="flex justify-between">
        <div className="">
          <p className='bg-blue-700 w-max text-white px-4 rounded-lg'>{useLang(`lang.${translation.lang}`)}</p>
        </div>
      </div>
      {groupeds.map((section) => (
        <div key={section.section} className='flex flex-col gap-2'>
          <h2 className='capitalize font-semibold'>{section.section}</h2>

          {section.groups.map((group) => (
            <div key={group.group} className='border rounded-md p-2'>
              <h3 className='capitalize border-b'>{group.group}</h3>

              {group.items.map((item, index) => {
                let tagName = item.tag?.replaceAll('_', ' ')
                return (
                  <div key={index} className='pl-4'>
                    <Input type='text' name={item.label} isLabel={!!item.tag} label={tagName} handleChange={handleChange} data={data} errors={errors} />
                  </div>
                )
              })}
            </div>
          ))}
        </div>
      ))}

      <div className="flex gap-2">
        {/* <button onClick={handleCopy} className={`btn btn-sm btn-primary btn-outline`}>
          <i className='fas fa-copy'></i>
          <span>Salin Terjemahan</span>
        </button> */}
        <button onClick={handleSubmit} disabled={processing} className={`btn btn-primary btn-sm`}>
          <i className={`fas fa-save ${processing && "loading"}`}></i>
          <span>Simpan</span>
        </button>
      </div>
    </div>
  )
}

export default Index
